<?php
/**
 * Plugin Name: RB Thumbnail Slider Widget
 * Description: Adds thumbnail slider widget to Elementor.
 * Version: 1.0.0
 * Author: Ryan Bronkema
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

function register_custom_elementor_widgets() {
    require_once( __DIR__ . '/widget/custom-thumbnail-slider-widget.php' );

    \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Custom_Thumbnail_Slider_Widget() );
}
add_action( 'elementor/widgets/widgets_registered', 'register_custom_elementor_widgets' );

function custom_elementor_widget_scripts() {
    // Enqueue Swiper.js library
    wp_enqueue_script( 'swiper', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js', [], '11.0.0', true );
    wp_enqueue_style( 'swiper', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css', [], '11.0.0' );

    // Enqueue custom slider script
    wp_enqueue_script( 'custom-thumbnail-slider-js', plugins_url( '/assets/js/custom-thumbnail-slider.js', __FILE__ ), [ 'swiper' ], false, true );
    
    // Enqueue custom slider styles
    wp_enqueue_style( 'custom-thumbnail-slider-css', plugins_url( '/assets/css/custom-thumbnail-slider.css', __FILE__ ) );
}
add_action( 'wp_enqueue_scripts', 'custom_elementor_widget_scripts' );