jQuery(document).ready(function ($) {
  // Initialize the thumbnail slider
  var thumbnailSlider = new Swiper(".thumbnail-slider", {
    spaceBetween: 10,
    slidesPerView: 2,
    freeMode: true,
    watchSlidesVisibility: true,
    watchSlidesProgress: true,
    breakpoints: {
      640: {
        slidesPerView: 2,
      },
      768: {
        slidesPerView: 3,
        spaceBetween: 20,
      },
      1024: {
        slidesPerView: 4,
        spaceBetween: 20,
      },
    },
  });

  // Initialize the main slider
  var mainSlider = new Swiper(".main-slider", {
    spaceBetween: 0,
    slidesPerView: 1,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    autoplay: {
      delay: 5000,
    },
    loop: true,
    thumbs: {
      swiper: thumbnailSlider,
    },
  });
});
