<?php

namespace NF_FU_VENDOR\Aws\Api;

/**
 * Represents a list shape.
 */
class ListShape extends Shape
{
    private $member;
    public function __construct(array $definition, ShapeMap $shapeMap)
    {
        $definition['type'] = 'list';
        parent::__construct($definition, $shapeMap);
    }
    /**
     * @return Shape
     * @throws \RuntimeException if no member is specified
     */
    public function getMember()
    {
        if (!$this->member) {
            if (!isset($this->definition['member'])) {
                throw new \RuntimeException('No member attribute specified');
            }
            $this->member = Shape::create($this->definition['member'], $this->shapeMap);
        }
        return $this->member;
    }
}
