<?php if ( ! defined( 'ABSPATH' ) ) exit;

return apply_filters( 'nf_stripe_payment_types', array(

    /**
     * Credit Card payment method
     */
    'card' => array(
        'type' => 'card',
        'description' => 'Card Payment',
        'response_data' => array(
            'brand',
            'last4',
            'wallet'
        )
    ),

    /**
     * Bank Debit payment methods
     * 
     * Allowed Currencies do not currently matter
     * Including them here for possible future functionality
     */
    'us_bank_account' => array(
        'type' => 'us_bank_account',
        'description' => 'ACH Direct Debit',
        'allowed_currencies' => array(
            'USD'
        ),
        'response_data' => array(
            'bank_name',
            'last4'
        )
    ),
    'bacs_debit' => array(
        'type' => 'bacs_debit',
        'description' => 'Bacs Direct Debit',
        'allowed_currencies' => array(
            'GBP'
        ),
        'response_data' => array(
            'last4'
        )
    ),
    'au_becs_debit' => array(
        'type' => 'au_becs_debit',
        'description' => 'BECS direct debit',
        'allowed_currencies' => array(
            'AUD'
        ),
        'response_data' => array(
            'last4'
        )
    ),
    'acss_debit' => array(
        'type' => 'acss_debit',
        'description' => 'Pre-authorized debit in Canada',
        'allowed_currencies' => array(
            'CAD',
            'USD'
        ),
        'response_data' => array(
            'bank_name',
            'last4'
        )
    ),
    'sepa_debit' => array(
        'type' => 'sepa_debit',
        'description' => 'SEPA debit',
        'allowed_currencies' => array(
            'EUR'
        ),
        'response_data' => array(
            'bank_code',
            'last4'
        )
    ),

    /**
     * Bank Redirect payment methods
     */
    'bancontact' => array(
        'type' => 'bancontact',
        'description' => 'Bancontact',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),
    'customer_balance' => array(
        'type' => 'customer_balance',
        'description' => 'Bank Transfer',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),
    'blik' => array(
        'type' => 'blik',
        'description' => 'BLIK',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),
    'eps' => array(
        'type' => 'eps',
        'description' => 'EPS',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
            'bank'
        )
    ),
    'fpx' => array(
        'type' => 'fpx',
        'description' => 'FPX',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
            'bank'
        )
    ),
    'giropay' => array(
        'type' => 'giropay',
        'description' => 'Giropay',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),
    'ideal' => array(
        'type' => 'ideal',
        'description' => 'iDEAL',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
            'bank'
        )
    ),
    'p24' => array(
        'type' => 'p24',
        'description' => 'P24',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
            'bank'
        )
    ),
    'sofort' => array(
        'type' => 'sofort',
        'description' => 'Sofort',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),

    /**
     * Buy Now, Pay Later payment methods
     */
    'affirm' => array(
        'type' => 'affirm',
        'description' => 'Affirm',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),
    'afterpay_clearpay' => array(
        'type' => 'afterpay_clearpay',
        'description' => 'Afterpay and Clearpay',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),
    'klarna' => array(
        'type' => 'klarna',
        'description' => 'Klarna',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),

    /**
     * Real-time payment methods
     */
    'paynow' => array(
        'type' => 'paynow',
        'description' => 'PayNow',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),
    'promptpay' => array(
        'type' => 'promptpay',
        'description' => 'PromptPay',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),

    /**
     * Voucher payment methods
     */
    'boleto' => array(
        'type' => 'boleto',
        'description' => 'Boleto',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),
    'konbini' => array(
        'type' => 'konbini',
        'description' => 'Konbini',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),
    'oxxo' => array(
        'type' => 'oxxo',
        'description' => 'OXXO',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),

    /**
     * Wallet payment methods
     */
    'alipay' => array(
        'type' => 'alipay',
        'description' => 'Alipay',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),
    'grabpay' => array(
        'type' => 'grabpay',
        'description' => 'GrabPay',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    ),
    'wechat_pay' => array(
        'type' => 'wechat_pay',
        'description' => 'WeChat Pay',
        'allowed_currencies' => array(
        ),
        'response_data' => array(
        )
    )

) );