<?php if ( ! defined( 'ABSPATH' ) ) exit;

final class NF_Stripe_Checkout_Admin_Metaboxes_Submission extends NF_Abstracts_SubmissionMetabox
{
    public function __construct()
    {
        parent::__construct();

        $this->_title = __( 'Stripe Payment', 'ninja-forms' );

        // if( $this->sub && ! $this->sub->get_extra_value( 'stripe_token' ) ){
        //     remove_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );
        // }
    }

    public function render_metabox( $post, $metabox )
    {
        if( ! $this->sub->get_extra_value( 'stripe_live' ) ){
            echo "<div style='text-align: center; background-color: yellow;'>";
            echo "<strong>";
            echo __( "This is a test transaction.", "ninja-forms-stripe" );
            echo "</strong>";
            echo "</div>";
        }

        echo "<dl>";

        echo "<dt>";
        echo __( "Payment Status", "ninja-forms-stripe" );
        echo "</dt>";

        echo "<dd>";
        echo $this->sub->get_extra_value( 'stripe_payment_status' );
        echo "</dd>";

        if( $this->sub->get_extra_value( 'stripe_token' ) ) {
            echo "<dt>";
            echo __( "Token", "ninja-forms-stripe" );
            echo "</dt>";

            echo "<dd>";
            echo $this->sub->get_extra_value( 'stripe_token' );
            echo "</dd>";
        }

        if( $this->sub->get_extra_value( 'stripe_customer_id' ) ) {
            echo "<dt>";
            echo __( "Customer ID", "ninja-forms-stripe" );
            echo "</dt>";

            echo "<dd>";
            echo $this->sub->get_extra_value( 'stripe_customer_id' );
            echo "</dd>";
        }

        if( $this->sub->get_extra_value( 'stripe_charge_id' ) ) {
            echo "<dt>";
            echo __( "Charge ID", "ninja-forms-stripe" );
            echo "</dt>";

            echo "<dd>";
            echo $this->sub->get_extra_value( 'stripe_charge_id' );
            echo "</dd>";
        }

        if( $this->sub->get_extra_value( 'stripe_subscription_id' ) ) {
            echo "<dt>";
            echo __( "Subscription ID", "ninja-forms-stripe" );
            echo "</dt>";

            echo "<dd>";
            echo $this->sub->get_extra_value( 'stripe_subscription_id' );
            echo "</dd>";
        }

        if( $this->sub->get_extra_value( 'stripe_payment_method_type' ) ) {
            $types = NF_Stripe_Checkout()->config( 'PaymentTypes' );
            $type = $this->sub->get_extra_value('stripe_payment_method_type');
            // Card types have an extra "wallet" setting.
            if( 'card' === $type && ! empty( $this->sub->get_extra_value('stripe_wallet') ) ) {
                $wallet_types = NF_Stripe_Checkout()->config( 'CardWalletTypes' );
                $type = $wallet_types[ $this->sub->get_extra_value('stripe_wallet') ][ 'description' ];
            } // If it's not a wallet type, check the normal list of types.
            elseif( isset( $types[ $type ] ) && isset( $types[ $type ][ 'description' ] ) ) {
                $type = $types[ $type ][ 'description' ];
            }
            echo "<dt>";
            echo $type;
            echo "</dt>";

            if( $this->sub->get_extra_value( 'stripe_brand' ) ) {
                echo "<dd>";
                echo $this->sub->get_extra_value( 'stripe_brand' );
                echo "</dd>";
            }
            if( $this->sub->get_extra_value( 'stripe_bank_name' ) ) {
                echo "<dd>";
                echo $this->sub->get_extra_value( 'stripe_bank_name' );
                echo "</dd>";
            }
            if( $this->sub->get_extra_value( 'stripe_bank_code' ) ) {
                echo "<dd>";
                echo $this->sub->get_extra_value( 'stripe_bank_code' );
                echo "</dd>";
            }
            if( $this->sub->get_extra_value( 'stripe_last4' ) ) {
                echo "<dd>";
                echo "**** **** **** ";
                echo $this->sub->get_extra_value( 'stripe_last4' );
                echo "</dd>";
            }
        }

        /**
         * Maintain this section for legacy data.
         * Value has been migrated to stripe_last4, as of September 2022.
         * Older data will still be read from this format.
         */
        if( $this->sub->get_extra_value( 'stripe_last_four' ) ) {
            echo "<dt>";
            echo __( "Card", "ninja-forms-stripe" );
            echo "</dt>";

            echo "<dd>";
            echo $this->sub->get_extra_value( 'stripe_brand' );
            echo "</dd>";
            echo "<dd>";
            echo "**** **** **** ";
            echo $this->sub->get_extra_value( 'stripe_last_four' );
            echo "</dd>";
        }

        echo "</dl>";

        if( $this->sub->get_extra_value( 'stripe_error' ) ) {
            echo "<dt style='color:#f00; font-weight:bold;'>";
            echo __( "Error Response", "ninja-forms-stripe" );
            echo "</dt>";

            echo "<dd>";
            echo $this->sub->get_extra_value( 'stripe_error' );
            echo "</dd>";
        }

    }
}