<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces;

// use \Stripe\PaymentIntent;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\PaymentIntent;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Session;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Subscription;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\PaymentMethod;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Customer;

/**
 * Define methods for integrating Stripe SDK into implmentations
 */
interface SdkInterface
{


    /**
     * Set API key for future requests
     *
     * @param string $apiKey
     * @return void
     */
    public function setApiKey(string $apiKey): void;

    /**
     * Get PaymentIntent object for given id
     *
     * @param array|string $id
     * @return PaymentIntent
     */
    public function getPaymentIntent($id): PaymentIntent;

    /**
     * Create a Session using array of parameters
     *
     * @param array $params
     * @return Session
     */
    public function createCheckoutSession(array $params): Session;

    /**
     * Get Checkout Session object for given id
     *
     * @param array|string $id
     * @return Session
     */
    public function getCheckoutSession($id): Session;

    /**
     * Get Subscription object for given id
     *
     * @param array|string $id
     * @return Subscription
     */
    public function getSubscription($id): Subscription;

    /**
     * Get PaymentMethod object for given id
     *
     * @param array|string $id
     * @return PaymentMethod
     */
    public function getPaymentMethod($id): PaymentMethod;

    /**
     * Get Customer object 
     *
     * @return Customer
     */
    public function getCustomer(): Customer;
}
