<?php 
namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Arrayable;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\LineItem;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Subscription as EntitiesSubscription;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Metadata;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Shipping;

/**
 * Requirements for Payment entity classes
 */
interface Payment extends Arrayable{

    /**
     * Attach customer email
     *
     * @param string $customer_email
     * @return void
     */
    public function attach_customer_email($customer_email);

    /**
     * Add subscription entity
     *
     * @param EntitiesSubscription $subscription
     * @return void
     */
    public function attach_subscription(EntitiesSubscription $subscription);

    /**
     * Add a line item entity
     *
     * @param LineItem $line_item
     * @return void
     */
    public function attach_line_item(LineItem $line_item);

    /**
     * Add metadata
     *
     * @param Metadata $metadata
     * @return void
     */
    public function attach_metadata(Metadata $metadata);

    /**
     * Add shipping entity
     *
     * @param Shipping $shipping
     * @return void
     */
    public function attach_shipping(Shipping $shipping);

    /**
     * Add payment method types
     * 
     * @param array $types
     * @return void
     */
    public function set_payment_method_types($types);

    /**
     * Add success URL
     *
     * @param string $success_url
     * @return void
     */
    public function set_success_url($success_url);

    /**
     * Add cancel URL
     *
     * @param string $cancel_url
     * @return void
     */
    public function set_cancel_url($cancel_url);

    /**
     * Return as associative array
     *
     * @return array
     */
    public function toArray();
}