<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Metadata;

/**
 * Saturday Drive implementation requirements for Customer
 */
interface Customer
{

    /**
     * Return Customer as associative array
     *
     * @return array
     */
    public function toArray(): array;

    /**
     * Update given customer id using metadata entity
     *
     * @param string $stripeCustomerId
     * @param Metadata $metadata
     * @return Customer
     */
    public function update(string $stripeCustomerId, Metadata $metadata): Customer;
}
