<?php 
namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Factories;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Payment as InterfacesPayment;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Payment201501;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Payment202208;

/**
 * Construct the requested PaymentObject
 *
 * Stripe has two data structures - a 'line_item' structure and 'price/product'
 * structure.  The line_item structure is being deprecated so the new default is
 * to use the price/product structure.  An optional boolean enables the use of
 * the older construct.
 */
class PaymentFactory{

    /**
     * Return a PaymentObject
     *
     * @param boolean $useLineItemStructure Use older 'line_item' construct
     * @return InterfacesPayment
     */
    public function makePaymentObject(bool $useLineItemStructure = false): InterfacesPayment
    {
        if($useLineItemStructure){
            $return = $this->makePayment201501Object();
        }else{
            $return = $this->makePayment202208Object();
        }

        return $return;
    }

    /**
     * Construct payment object using 'line_item' construct
     *
     * @return InterfacesPayment
     */
    public function makePayment201501Object( ): InterfacesPayment
    {
        $return = new Payment201501();

        return $return;
    }

    /**
     * Construct payment object using 'price/product' construct
     *
     * @return InterfacesPayment
     */
    public function makePayment202208Object( ): InterfacesPayment
    {
        $return = new Payment202208();

        return $return;
    }
}