<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Subscription as  EntitiesSubscription;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\LineItem;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Payment as InterfacesPayment;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Metadata;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Shipping;

class Payment201501 implements InterfacesPayment
{

    /** @var array */
    protected $payment_method_types = array();

    /** @var string */
    protected $customer_email;

    /** @var array [LineItem] */
    protected $line_items;

    /** @var EntitiesSubscription */
    protected $subscription;

    /** @var PaymentIntent\Metadata */
    protected $metadata;

    /** @var PaymentIntent\Shipping */
    protected $shipping;

    /** @var string */
    protected $success_url;

    /** @var string */
    protected $cancel_url;

    /** @inheritDoc */
    public function attach_customer_email($customer_email)
    {
        $this->customer_email = $customer_email;
    }

    /** @inheritDoc */
    public function attach_subscription(EntitiesSubscription $subscription)
    {
        $this->subscription = $subscription;
    }

    /** @inheritDoc */
    public function attach_line_item(LineItem $line_item)
    {
        $this->line_items[] = $line_item;
    }

    /** @inheritDoc */
    public function attach_metadata(Metadata $metadata)
    {
        $this->metadata = $metadata;
    }

    /** @inheritDoc */
    public function attach_shipping(Shipping $shipping)
    {
        $this->shipping = $shipping;
    }

    /** @inheritDoc */
    public function set_payment_method_types($types)
    {
        $this->payment_method_types = $types;
    }

    /** @inheritDoc */
    public function set_success_url($success_url)
    {
        $this->success_url = $success_url;
    }

    /** @inheritDoc */
    public function set_cancel_url($cancel_url)
    {
        $this->cancel_url = $cancel_url;
    }

    /** @inheritDoc */
    public function toArray()
    {
        $payment_data = [
            'payment_method_types' => $this->payment_method_types,
            'success_url' => $this->success_url,
            'cancel_url' => $this->cancel_url,
        ];

        if ($this->customer_email) {
            $payment_data['customer_email'] = $this->customer_email;
            $payment_data['customer_creation'] = 'always';
        }

        if ($this->subscription) {
            $payment_data['subscription_data'] = $this->subscription->toArray();
        }

        if (!empty($this->line_items)) {
            $payment_data['line_items'] = array_map(function ($line_item) {
                return $line_item->toArray();
            }, $this->line_items);
        }

        if ($this->metadata) {
            if ($this->subscription) {
                $payment_data['subscription_data']['metadata'] = $this->metadata->toArray();
            } else {
                $payment_data['payment_intent_data']['metadata'] = $this->metadata->toArray();
            }
        }

        if ($this->shipping && !$this->subscription) {
            $payment_data['payment_intent_data']['shipping'] = $this->shipping->toArray();
        }

        return $payment_data;
    }
}
