<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Arrayable;

class Metadata implements Arrayable
{
    /** @var array */
    protected $metadata = array();

    /** 
     * Constructs instance of Metadata from associative array
     */
    public static function create($action_settings)
    {
        $payment_intent_metadata = new static();
        if (isset($action_settings['stripe_metadata'])) {
            foreach ($action_settings['stripe_metadata'] as $metadata) {
                
                if(empty($metadata['key']) && '0' !== $metadata['key']){
                    continue;
                }

                $payment_intent_metadata->metadata[$metadata['key']] = $metadata['value'];
            }
        }
        return $payment_intent_metadata;
    }

    /**
     * Does metadata have values
     *
     * @return boolean
     */
    public function has_metadata()
    {
        return 0 < count($this->metadata);
    }

    /**
     * Return metadata as associative array
     *
     * @return void
     */
    public function toArray()
    {
        return $this->metadata;
    }
}
