<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\LineItem as InterfacesLineItem;

/**
 * Line Item migration to Stripe version 2022-08-01
 */
class LineItem202208 implements InterfacesLineItem
{

    /** @var string */
    protected $item_name = '';

    /** @var string */
    protected $item_description = '';

    /** @var array */
    protected $item_images = array();

    /** @var string */
    protected $item_amount = '';

    /** @var string */
    protected $item_currency = '';

    /** @var int */
    protected $item_quantity = 1;

    public function __construct($name, $amount, $currency, $quantity = 1)
    {
        $this->item_name = $name;

        $this->item_amount = $amount;

        $this->item_currency = $currency;

        $this->item_quantity = $quantity;
    }

    /** @inheritDoc */
    public function set_description($description)
    {
        $this->item_description = $description;
    }

    /** @inheritDoc */
    public function add_image($image)
    {
        $this->item_images[] = $image;
    }

    /** @inheritDoc */
    public function toArray()
    {
        $return_item = [
            'name' => $this->item_name,
            'description' => $this->item_description,
            'images' => $this->item_images,
            'amount' => $this->item_amount,
            'quantity' => $this->item_quantity,
            'currency' => $this->item_currency,
        ];

        if (0 === strlen($this->item_description)) {
            unset($return_item['description']);
        }

        return $return_item;
    }
}
