<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Adapters;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Customer as InterfacesCustomer;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Metadata;

use \Stripe\Customer as StripeCustomer;

/**
 * Saturday Drive implementation for Customer
 */
class Customer implements InterfacesCustomer
{

    /** @var StripeCustomer */
    protected $stripeCustomer;

    /** @inheritDoc */
    public function update(string $stripeCustomerId, Metadata $metadata): InterfacesCustomer
    {
        $this->stripeCustomer = StripeCustomer::update($stripeCustomerId, array('metadata' => $metadata->toArray()));
        return $this;
    }

    /** @inheritDoc */
    public function toArray(): array
    {
        return $this->stripeCustomer->toArray();
    }
}
