<?php if ( ! defined( 'ABSPATH' ) ) exit;

$loggerMarkup = sprintf('<span class = "button" id="stripe_clear_debug_logger">%s</></span><br /><span> %s</span><br /><br />',__( 'Clear debug log', 'ninja-forms-scheduled-exports' ),__( 'Clear logs when debugging is complete and the logger has been turned off.', 'ninja-forms-scheduled-exports' ));
$loggerMarkup .= sprintf('<span class = "button" id="stripe_download_debug_logger">%s</span><br /><span> %s</span>',__( 'Download debug log', 'ninja-forms-scheduled-exports' ),__( 'Providing log data with support requests helps diagnose issues.', 'ninja-forms-scheduled-exports' ));


return apply_filters( 'nf_stripe_plugin_settings', array(

    /*
    |--------------------------------------------------------------------------
    | Test Credentials
    |--------------------------------------------------------------------------
    */

    'stripe_test_publishable_key' => array(
        'id'    => 'stripe_test_publishable_key',
        'type'  => 'textbox',
        'label' => sprintf( __( 'Test Publishable Key%s', 'ninja-forms-stripe' ), '<span id="nf-stripe"></span>' ),
    ),

    'stripe_test_secret_key' => array(
        'id'    => 'stripe_test_secret_key',
        'type'  => 'textbox',
        'label' => __( 'Test Secret Key', 'ninja-forms-stripe' ),
    ),

    /*
    |--------------------------------------------------------------------------
    | Divider
    |--------------------------------------------------------------------------
    */

    'stripe_divider_credentials' => array(
        'id'    => 'stripe_divider_credentials',
        'type'  => 'html',
        'label' => '',
        'html' => '<hr />'
    ),

    /*
    |--------------------------------------------------------------------------
    | Live Credentials
    |--------------------------------------------------------------------------
    */

    'stripe_live_publishable_key' => array(
        'id'    => 'stripe_live_publishable_key',
        'type'  => 'textbox',
        'label' => __( 'Live Publishable Key', 'ninja-forms-stripe' ),
    ),

    'stripe_live_secret_key' => array(
        'id'    => 'stripe_live_secret_key',
        'type'  => 'textbox',
        'label' => __( 'Live Secret Key', 'ninja-forms-stripe' ),
    ),
    /*
    |--------------------------------------------------------------------------
    | Divider
    |--------------------------------------------------------------------------
    */

    'stripe_divider_debug_log' => array(
        'id'    => 'stripe_divider_debug_log',
        'type'  => 'html',
        'label' => '',
        'html' => '<hr />'
    ),
    'stripe_turn_on_debug_logger' => array(
        'id'    => 'stripe_turn_on_debug_logger',
        'type'  => 'checkbox',
        'label' => __('Turn on Debug Logger','ninja-forms-stripe'),
        'desc'=>sprintf('%s <a href="https://ninjaforms.com/docs/stripe/">%s</a> ',__('The debug logger records diagnostic data that can be exported and sent to our support team if you suspect there\'s an issue with this add-on. Only active when turned on.', 'ninja-forms-stripe'),__('Learn more', 'ninja-forms-stripe')) // Link to document page for plugin
    ),
    'stripe_logger_commands' => array(
        'id'    => 'stripe_logger_commands',
        'type'  => 'html',
        'label' => __('Logger Commands', 'ninja-forms-stripe'),
        'html' => $loggerMarkup,
    ),

));
