<?php

use NinjaForms\Includes\Entities\MetaboxOutputEntity;


class NF_Stripe_Checkout_Admin_Metaboxes_MetaboxEntityPaymentStatus
{

    public function handle($extraValue, $nfSub): ?MetaboxOutputEntity
    {
        $return = null;

        // If payment status is not set, there is nothing to display
        // If it is set, then dislay all values to contain within one metabox
        if (!$nfSub->get_extra_value('stripe_payment_status')) {
            return $return;
        }

        $labelValueCollection = self::extractResponses($nfSub);

        if (!empty($labelValueCollection)) {

            $array = [
                'title' => __( 'Stripe Payment', 'ninja-forms' ),
                'labelValueCollection' => $labelValueCollection

            ];

            $return = MetaboxOutputEntity::fromArray($array);
        }

        return $return;
    }

    /**
     * Extract all extra data to be displayed
     *
     * @param [type] $nfSub
     * @return array
     */
    protected  static function extractResponses($nfSub): array
    {

        $return = [];
        if (!$nfSub->get_extra_value('stripe_live')) {
            $return[] = [
                'label' =>'',
                'value' => __( "This is a test transaction.", "ninja-forms-stripe" ),
                'styling' => 'alert'
            ];
        }

        $return[] = [
            'label' => __( "Payment Status", "ninja-forms-stripe" ),
            'value' => $nfSub->get_extra_value('stripe_payment_status'),
            'styling' => ''
        ];

        if ($nfSub->get_extra_value('stripe_token')) {
            $return[] = [
                'label' =>__( "Token", "ninja-forms-stripe" ),
                'value' => $nfSub->get_extra_value('stripe_token'),
                'styling' => ''
            ];
        }

        if ($nfSub->get_extra_value('stripe_customer_id')) {
            $return[] = [
                'label' =>__( "Customer ID", "ninja-forms-stripe" ),
                'value' => $nfSub->get_extra_value('stripe_customer_id'),
                'styling' => ''
            ];
        }

        if ($nfSub->get_extra_value('stripe_charge_id')) {
            $return[] = [
                'label' => __( "Charge ID", "ninja-forms-stripe" ),
                'value' => $nfSub->get_extra_value('stripe_charge_id'),
                'styling' => ''
            ];
        }
        
        if ($nfSub->get_extra_value('stripe_subscription_id')) {

            $return[] = [
                'label' => __( "Subscription ID", "ninja-forms-stripe" ),
                'value' => $nfSub->get_extra_value('stripe_subscription_id'),
                'styling' => ''
            ];
        }
        
        if ($nfSub->get_extra_value('stripe_payment_method_type')) {
            $types = NF_Stripe_Checkout()->config( 'PaymentTypes' );
            $type = $nfSub->get_extra_value('stripe_payment_method_type');
            // Card types have an extra "wallet" setting.
            if( 'card' === $type && ! empty( $nfSub->get_extra_value('stripe_wallet') ) ) {
                $wallet_types = NF_Stripe_Checkout()->config( 'CardWalletTypes' );
                $type = $wallet_types[ $nfSub->get_extra_value('stripe_wallet') ][ 'description' ];
            } // If it's not a wallet type, check the normal list of types.
            elseif( isset( $types[ $type ] ) && isset( $types[ $type ][ 'description' ] ) ) {
                $type = $types[ $type ][ 'description' ];
            }
            $return[] = [
                'label' =>  __("Payment Method", "ninja-forms-stripe"),
                'value' => $type,
                'styling' => ''
            ];
        }

        if ($nfSub->get_extra_value('stripe_brand')) {
            $return[] = [
                'label' =>  __("Card", "ninja-forms-stripe"),
                'value' => $nfSub->get_extra_value('stripe_brand'),
                'styling' => ''
            ];
        }

        if ($nfSub->get_extra_value('stripe_bank_name')) {
            $return[] = [
                'label' =>  __("Bank", "ninja-forms-stripe"),
                'value' => $nfSub->get_extra_value('stripe_bank_name'),
                'styling' => ''
            ];
        }

        if ($nfSub->get_extra_value('stripe_bank_code')) {
            $return[] = [
                'label' =>  __("Bank", "ninja-forms-stripe"),
                'value' => $nfSub->get_extra_value('stripe_bank_code'),
                'styling' => ''
            ];
        }

        if ($nfSub->get_extra_value('stripe_last4')) {
            $return[] = [
                'label' =>  __("Last 4", "ninja-forms-stripe"),
                'value' => '**** **** **** ' . $nfSub->get_extra_value('stripe_last4'),
                'styling' => ''
            ];
        }

        /**
         * Maintain this section for legacy data.
         * Value has been migrated to stripe_last4, as of September 2022.
         * Older data will still be read from this format.
         */
        if ($nfSub->get_extra_value('stripe_last_four')) {

            $return[] = [
                'label' =>  __("Payment Method", "ninja-forms-stripe"),
                'value' => 'Card',
                'styling' => ''
            ];

            $return[] = [
                'label' =>  __("Card", "ninja-forms-stripe"),
                'value' => $nfSub->get_extra_value('stripe_brand'),
                'styling' => ''
            ];

            $return[] = [
                'label' => __("Last 4", "ninja-forms-stripe"),
                'value' => '**** **** **** ' . $nfSub->get_extra_value('stripe_last_four'),
                'styling' => ''
            ];
        }

        if ($nfSub->get_extra_value('stripe_error')) {

            $return[] = [
                'label' => __( "Error Response", "ninja-forms-stripe" ),
                'value' => $nfSub->get_extra_value('stripe_error'),
                'styling' => 'alert'
            ];
        }

        return $return;
    }

}
