<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\SdkInterface;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Adapters\PaymentIntent;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Adapters\Session;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Adapters\Subscription;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Adapters\PaymentMethod;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Adapters\Customer;
use \Stripe\Stripe;

class SdkAdapter implements SdkInterface
{

    /** @inheritDoc */
    public function setApiKey(string $apiKey): void
    {
        Stripe::setApiKey($apiKey);
    }

    /** @inheritDoc */
    public function getPaymentIntent($id): PaymentIntent
    {
        $return = new PaymentIntent($id);

        return $return;
    }

    /** @inheritDoc */
    public function createCheckoutSession(array $params): Session
    {
        $return = (new Session())->create($params);

        return $return;
    }

    /** @inheritDoc */
    public function getCheckoutSession($id): Session
    {
        $return = (new Session())->retrieveSession($id);

        return $return;
    }

    /** @inheritDoc */
    public function getSubscription($id): Subscription
    {
        $return = (new Subscription())->retrieve($id);

        return $return;
    }

    /** @inheritDoc */
    public function getPaymentMethod($id): PaymentMethod
    {
        $return = (new PaymentMethod())->retrievePaymentMethod($id);

        return $return;
    }

    /** @inheritDoc */
    public function getCustomer(): Customer
    {
        $return = new Customer();

        return $return;
    }
}
