<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces;

use \Stripe\Checkout\Session as StripeSession;

/**
 * Saturday Drive implementation requirements for Stripe Session
 */
interface Session
{

    /**
     * Return object as array
     *
     * @return array
     */
    public function toArray(): array;

    /**
     * Return Session for given id
     *
     * @param string $id
     * @return Session
     */
    public function retrieveSession(string $id): Session;

    /**
     * Return Session Id
     *
     * @return string
     */
    public function getSessionId();

    /**
     * Return PaymentIntent Id
     *
     * @return string
     */
    public function getPaymentIntent();

    /**
     * Return Subscription Id
     *
     * @return void
     */
    public function getSubscriptionId();

    /**
     * Return Stripe Session (not adapter Session)
     *
     * @return StripeSession
     */
    public function getStripeSession(): StripeSession;

    /**
     * Get payment status
     *
     * @return string
     */
    public function getPaymentStatus( ): string;
}
