<?php 
namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces;

/**
 * Saturday Drive implementation requirements for PaymentIntent
 */
interface PaymentIntent{

    /**
     * Update PaymentIntent with associative array of parameters
     *
     * @param array $params
     * @return PaymentIntent
     */
    public function update( array $params): PaymentIntent;
    
    /**
     * Does Payment intent have charge
     *
     * @return boolean
     */
    public function hasCharge( ): bool;

    /**
     * Return charge ID
     *
     * @return string
     */
    public function getChargeId( ): string;

    /**
     * Return customer ID
     *
     * @return string
     */
    public function getCustomerId( ): string;

    /**
     * Get Payment Method Id
     *
     * @return string
     */
    public function getPaymentMethodId( ): string;

    /**
     * Return object as associative array
     *
     * @return array
     */
    public function toArray( ): array;
}