<?php 
namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Arrayable;

/**
 * Required methods for LineItem classes
 */
interface LineItem extends Arrayable{
    /**
     * Set line item description
     *
     * @param string $description
     * @return void
     */
    public function set_description($description);

    /**
     * Add line item image
     *
     * @param  $image
     * @return void
     */
    public function add_image($image);

    /**
     * Return line item as array
     *
     * @return array
     */
    public function toArray();
}