<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Subscription as EntitiesSubscription;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\LineItem;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Payment as InterfacesPayment;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Metadata;
use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Entities\Shipping;

class Payment202208 implements InterfacesPayment
{
    /** @var string */
    protected $mode = 'payment';

    /** @var array */
    protected $payment_method_types = array();

    /** @var string */
    protected $customer_email;

    /** @var array [LineItem] */
    protected $line_items;

    /** @var EntitiesSubscription */
    protected $subscription;

    /** @var Metadata */
    protected $metadata;

    /** @var Shipping */
    protected $shipping;

    /** @var string */
    protected $success_url;

    /** @var string */
    protected $cancel_url;

    /** @inheritDoc */
    public function attach_customer_email($customer_email)
    {
        $this->customer_email = $customer_email;
    }

    /** @inheritDoc */
    public function attach_subscription(EntitiesSubscription $subscription)
    {
        $this->subscription = $subscription;
        $this->mode = 'subscription';
    }

    /** @inheritDoc */
    public function attach_line_item(LineItem $line_item)
    {
        // $this->line_items[] = $line_item;
        $this->line_items[''] = $line_item;
    }

    /** @inheritDoc */
    public function attach_metadata(Metadata $metadata)
    {
        $this->metadata = $metadata;
    }

    /** @inheritDoc */
    public function attach_shipping(Shipping $shipping)
    {
        $this->shipping = $shipping;
    }

    /** @inheritDoc */
    public function set_payment_method_types($types)
    {
        $this->payment_method_types = $types;
    }

    /** @inheritDoc */
    public function set_success_url($success_url)
    {
        $this->success_url = $success_url;
    }

    /** @inheritDoc */
    public function set_cancel_url($cancel_url)
    {
        $this->cancel_url = $cancel_url;
    }

    /** @inheritDoc */
    public function toArray()
    {
        $payment_data = [
            'payment_method_types' => $this->payment_method_types,
            'success_url' => $this->success_url,
            'cancel_url' => $this->cancel_url,
            'mode' => $this->mode
        ];

        if ($this->customer_email) {
            $payment_data['customer_email'] = $this->customer_email;
        }

        if ($this->subscription) {
            $payment_data['subscription_data'] = $this->subscription->toArray();
        }

        if (!empty($this->line_items)) {
            foreach ($this->line_items as $line_item) {

                $lineItemArray = $line_item->toArray();

                $price_data = [
                    'currency' => $lineItemArray['currency'],
                    'unit_amount' => $lineItemArray['amount'],
                    'product_data' => [
                        'name' => $lineItemArray['name'],
                        'description'=>$lineItemArray['description'],
                        'images' => $lineItemArray['images']
                    ]
                ];

                $payment_data['line_items'][] = [
                    'price_data' => $price_data,
                    'quantity' => 1
                ];
            }
        }

        if ($this->metadata) {
            if ($this->subscription) {
                $payment_data['subscription_data']['metadata'] = $this->metadata->toArray();
            } else {
                $payment_data['payment_intent_data']['metadata'] = $this->metadata->toArray();
            }
        }

        if ($this->shipping && !$this->subscription) {
            $payment_data['payment_intent_data']['shipping'] = $this->shipping->toArray();
        }

        return $payment_data;
    }
}
