<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Adapters;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\Session as InterfacesSession;
use \Stripe\Checkout\Session as StripeSession;


class Session implements InterfacesSession
{
    /** @var StripeSession */
    protected $session;

    /** @inheritDoc */
    public function create(array $params): Session
    {
        $this->session = StripeSession::create($params);
        return $this;
    }

    /** @inheritDoc */
    public function retrieveSession(string $id): Session
    {
        $this->session = StripeSession::retrieve($id);
        return $this;
    }

    /** @inheritDoc */
    public function toArray(): array
    {

        return $this->session->toArray();
    }

    /** @inheritDoc */
    public function getSubscriptionId()
    {
        return $this->session->subscription;
    }

    /** @inheritDoc */
    public function getStripeSession(): StripeSession
    {
        return $this->session;
    }

    /** @inheritDoc */
    public function getSessionId()
    {
        return $this->session->id;
    }

    /** @inheritDoc */
    public function getPaymentIntent()
    {
        return $this->session->payment_intent;
    }

    /** @inheritDoc */
    public function getPaymentStatus( ): string
    {
        return $this->session->payment_status;
    }
}
