<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Adapters;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\PaymentMethod as InterfacesPaymentMethod;
use \Stripe\PaymentMethod as StripePaymentMethod;

class PaymentMethod implements InterfacesPaymentMethod
{

    /** @var StripePaymentMethod */
    protected $paymentMethod;

    /** @inheritDoc */
    public function retrievePaymentMethod(string $id): PaymentMethod
    {
        $this->paymentMethod = StripePaymentMethod::retrieve($id);

        return $this;
    }

    public function getType(): string
    {
        return $this->paymentMethod->type;
    }

    public function getDescription(): string
    {
        $types = NF_Stripe_Checkout()->config( 'PaymentTypes' );
        $type = $this->getType();
        // Card types have a "wallet" setting.
        if( 'card' === $type && ! empty( $this->paymentMethod->card->wallet ) ) {
            $wallet_types = NF_Stripe_Checkout()->config( 'CardWalletTypes' );
            $wallet_type = $this->paymentMethod->card->wallet->type;
            return $wallet_types[ $wallet_type ][ 'description' ];
        }
        if( isset( $types[ $type ] ) && isset( $types[ $type ][ 'description' ] ) ) {
            $type = $types[ $type ][ 'description' ];
        }
        return $type;
    }

    public function getDetails(): array
    {
        $types = NF_Stripe_Checkout()->config( 'PaymentTypes' );
        $type = $this->getType();
        $response = array(
            'payment_method_type' => $type
        );
        if( in_array( $type, array_keys( $types ) ) && isset( $types[ $type ][ 'response_data' ] ) ) {
            foreach( $types[ $type ][ 'response_data' ] as $detail ) {
                if( 'card' === $type && 'wallet' === $detail ) {
                    $response[ $detail ] = $this->paymentMethod->card->wallet->type;
                    continue 1;
                }
                $response[ $detail ] = $this->paymentMethod->{$type}->{$detail};
            }
        }
        return $response;
    }

    /** @inheritDoc */
    public function getCardBrand(): string
    {
        if( 'card' !== $this->getType() ) return '';
        return $this->paymentMethod->card->brand;
    }

    /** @inheritDoc */
    public function getCardLastFour(): string
    {
        if( 'card' !== $this->getType() ) return '';
        return $this->paymentMethod->card->last4;
    }

    /** @inheritDoc */
    public function toArray(): array
    {
        return $this->paymentMethod->toArray();
    }
}
