<?php

namespace NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Adapters;

use NinjaForms\StripeCheckout\Common\Adapters\StripeCheckout\Interfaces\PaymentIntent as InterfacesPaymentIntent;
use \Stripe\PaymentIntent as StripePaymentIntent;
use \Stripe\Charge;

class PaymentIntent implements InterfacesPaymentIntent
{

    /** @var string */
    protected $id;

    /** @var StripePaymentIntent */
    protected $stripePaymentIntent;

    /** @var bool */
    protected $hasCharge;

    /** @var Charge */
    protected $charge;

    public function __construct($id)
    {
        $this->id = $id;

        $this->constructPaymentIntent();

        $this->extractCharge();
    }

    /**
     * Construct PaymentIntent object from $id
     *
     * @return void
     */
    protected function constructPaymentIntent(): void
    {
        $this->stripePaymentIntent = StripePaymentIntent::retrieve($this->id);
    }

    /**
     * Extract charge from PaymentIntent
     *
     * @return void
     */
    protected function extractCharge(): void
    {
        if (isset($this->stripePaymentIntent->charges->data)) {

            $this->charge = reset($this->stripePaymentIntent->charges->data);
        }

        $this->hasCharge = $this->charge ? true : false;
    }

    /** @inheritDoc */
    public function hasCharge(): bool
    {
        return $this->hasCharge;
    }

    /** @inheritDoc */
    public function update(array $params): PaymentIntent
    {
        StripePaymentIntent::update($this->id, $params);

        return $this;
    }

    /** @inheritDoc */
    public function getChargeId(): string
    {
        if ($this->hasCharge) {
            $return = $this->charge->id;
        } else {
            $return = '';
        }

        return $return;
    }

    /** @inheritDoc */
    public function getCustomerId(): string
    {
        if ($this->hasCharge && is_string($this->stripePaymentIntent->customer)) {

            $return = $this->stripePaymentIntent->customer;
        } else {

            $return = '';
        }

        return $return;
    }

    /** @inheritDoc */
    public function getPaymentMethodId( ): string{
        
        return $this->stripePaymentIntent->payment_method;
    }

    /** @inheritDoc */
    public function toArray(): array
    {

        return $this->stripePaymentIntent->toArray();
    }
}
