<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * CardPaymentDetails Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class CardPaymentDetails implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'status' => 'string',
        'card' => '\SquareConnect\Model\Card',
        'entry_method' => 'string',
        'cvv_status' => 'string',
        'avs_status' => 'string',
        'auth_result_code' => 'string',
        'application_identifier' => 'string',
        'application_name' => 'string',
        'application_cryptogram' => 'string',
        'verification_method' => 'string',
        'verification_results' => 'string',
        'statement_description' => 'string',
        'errors' => '\SquareConnect\Model\Error[]'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'status' => 'status',
        'card' => 'card',
        'entry_method' => 'entry_method',
        'cvv_status' => 'cvv_status',
        'avs_status' => 'avs_status',
        'auth_result_code' => 'auth_result_code',
        'application_identifier' => 'application_identifier',
        'application_name' => 'application_name',
        'application_cryptogram' => 'application_cryptogram',
        'verification_method' => 'verification_method',
        'verification_results' => 'verification_results',
        'statement_description' => 'statement_description',
        'errors' => 'errors'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'status' => 'setStatus',
        'card' => 'setCard',
        'entry_method' => 'setEntryMethod',
        'cvv_status' => 'setCvvStatus',
        'avs_status' => 'setAvsStatus',
        'auth_result_code' => 'setAuthResultCode',
        'application_identifier' => 'setApplicationIdentifier',
        'application_name' => 'setApplicationName',
        'application_cryptogram' => 'setApplicationCryptogram',
        'verification_method' => 'setVerificationMethod',
        'verification_results' => 'setVerificationResults',
        'statement_description' => 'setStatementDescription',
        'errors' => 'setErrors'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'status' => 'getStatus',
        'card' => 'getCard',
        'entry_method' => 'getEntryMethod',
        'cvv_status' => 'getCvvStatus',
        'avs_status' => 'getAvsStatus',
        'auth_result_code' => 'getAuthResultCode',
        'application_identifier' => 'getApplicationIdentifier',
        'application_name' => 'getApplicationName',
        'application_cryptogram' => 'getApplicationCryptogram',
        'verification_method' => 'getVerificationMethod',
        'verification_results' => 'getVerificationResults',
        'statement_description' => 'getStatementDescription',
        'errors' => 'getErrors'
    );
  
    /**
      * $status The card payment's current state. It can be one of: `AUTHORIZED`, `CAPTURED`, `VOIDED`, `FAILED`.
      * @var string
      */
    protected $status;
    /**
      * $card The credit card's non-confidential details.
      * @var \SquareConnect\Model\Card
      */
    protected $card;
    /**
      * $entry_method The method used to enter the card's details for the payment.  Can be `KEYED`, `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`.
      * @var string
      */
    protected $entry_method;
    /**
      * $cvv_status Status code returned from the Card Verification Value (CVV) check. Can be `CVV_ACCEPTED`, `CVV_REJECTED`, `CVV_NOT_CHECKED`.
      * @var string
      */
    protected $cvv_status;
    /**
      * $avs_status Status code returned from the Address Verification System (AVS) check. Can be `AVS_ACCEPTED`, `AVS_REJECTED`, `AVS_NOT_CHECKED`.
      * @var string
      */
    protected $avs_status;
    /**
      * $auth_result_code Status code returned by the card issuer that describes the payment's authorization status.
      * @var string
      */
    protected $auth_result_code;
    /**
      * $application_identifier For EMV payments, identifies the EMV application used for the payment.
      * @var string
      */
    protected $application_identifier;
    /**
      * $application_name For EMV payments, the human-readable name of the EMV application used for the payment.
      * @var string
      */
    protected $application_name;
    /**
      * $application_cryptogram For EMV payments, the cryptogram generated for the payment.
      * @var string
      */
    protected $application_cryptogram;
    /**
      * $verification_method For EMV payments, method used to verify the cardholder's identity.  Can be one of `PIN`, `SIGNATURE`, `PIN_AND_SIGNATURE`, `ON_DEVICE`, or `NONE`.
      * @var string
      */
    protected $verification_method;
    /**
      * $verification_results For EMV payments, the results of the cardholder verification.  Can be one of `SUCCESS`, `FAILURE`, or `UNKNOWN`.
      * @var string
      */
    protected $verification_results;
    /**
      * $statement_description The statement description sent to the card networks.  Note: The actual statement description will vary and is likely to be truncated and appended with additional information on a per issuer basis.
      * @var string
      */
    protected $statement_description;
    /**
      * $errors Information on errors encountered during the request.
      * @var \SquareConnect\Model\Error[]
      */
    protected $errors;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["status"])) {
              $this->status = $data["status"];
            } else {
              $this->status = null;
            }
            if (isset($data["card"])) {
              $this->card = $data["card"];
            } else {
              $this->card = null;
            }
            if (isset($data["entry_method"])) {
              $this->entry_method = $data["entry_method"];
            } else {
              $this->entry_method = null;
            }
            if (isset($data["cvv_status"])) {
              $this->cvv_status = $data["cvv_status"];
            } else {
              $this->cvv_status = null;
            }
            if (isset($data["avs_status"])) {
              $this->avs_status = $data["avs_status"];
            } else {
              $this->avs_status = null;
            }
            if (isset($data["auth_result_code"])) {
              $this->auth_result_code = $data["auth_result_code"];
            } else {
              $this->auth_result_code = null;
            }
            if (isset($data["application_identifier"])) {
              $this->application_identifier = $data["application_identifier"];
            } else {
              $this->application_identifier = null;
            }
            if (isset($data["application_name"])) {
              $this->application_name = $data["application_name"];
            } else {
              $this->application_name = null;
            }
            if (isset($data["application_cryptogram"])) {
              $this->application_cryptogram = $data["application_cryptogram"];
            } else {
              $this->application_cryptogram = null;
            }
            if (isset($data["verification_method"])) {
              $this->verification_method = $data["verification_method"];
            } else {
              $this->verification_method = null;
            }
            if (isset($data["verification_results"])) {
              $this->verification_results = $data["verification_results"];
            } else {
              $this->verification_results = null;
            }
            if (isset($data["statement_description"])) {
              $this->statement_description = $data["statement_description"];
            } else {
              $this->statement_description = null;
            }
            if (isset($data["errors"])) {
              $this->errors = $data["errors"];
            } else {
              $this->errors = null;
            }
        }
    }
    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
  
    /**
     * Sets status
     * @param string $status The card payment's current state. It can be one of: `AUTHORIZED`, `CAPTURED`, `VOIDED`, `FAILED`.
     * @return $this
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Gets card
     * @return \SquareConnect\Model\Card
     */
    public function getCard()
    {
        return $this->card;
    }
  
    /**
     * Sets card
     * @param \SquareConnect\Model\Card $card The credit card's non-confidential details.
     * @return $this
     */
    public function setCard($card)
    {
        $this->card = $card;
        return $this;
    }
    /**
     * Gets entry_method
     * @return string
     */
    public function getEntryMethod()
    {
        return $this->entry_method;
    }
  
    /**
     * Sets entry_method
     * @param string $entry_method The method used to enter the card's details for the payment.  Can be `KEYED`, `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`.
     * @return $this
     */
    public function setEntryMethod($entry_method)
    {
        $this->entry_method = $entry_method;
        return $this;
    }
    /**
     * Gets cvv_status
     * @return string
     */
    public function getCvvStatus()
    {
        return $this->cvv_status;
    }
  
    /**
     * Sets cvv_status
     * @param string $cvv_status Status code returned from the Card Verification Value (CVV) check. Can be `CVV_ACCEPTED`, `CVV_REJECTED`, `CVV_NOT_CHECKED`.
     * @return $this
     */
    public function setCvvStatus($cvv_status)
    {
        $this->cvv_status = $cvv_status;
        return $this;
    }
    /**
     * Gets avs_status
     * @return string
     */
    public function getAvsStatus()
    {
        return $this->avs_status;
    }
  
    /**
     * Sets avs_status
     * @param string $avs_status Status code returned from the Address Verification System (AVS) check. Can be `AVS_ACCEPTED`, `AVS_REJECTED`, `AVS_NOT_CHECKED`.
     * @return $this
     */
    public function setAvsStatus($avs_status)
    {
        $this->avs_status = $avs_status;
        return $this;
    }
    /**
     * Gets auth_result_code
     * @return string
     */
    public function getAuthResultCode()
    {
        return $this->auth_result_code;
    }
  
    /**
     * Sets auth_result_code
     * @param string $auth_result_code Status code returned by the card issuer that describes the payment's authorization status.
     * @return $this
     */
    public function setAuthResultCode($auth_result_code)
    {
        $this->auth_result_code = $auth_result_code;
        return $this;
    }
    /**
     * Gets application_identifier
     * @return string
     */
    public function getApplicationIdentifier()
    {
        return $this->application_identifier;
    }
  
    /**
     * Sets application_identifier
     * @param string $application_identifier For EMV payments, identifies the EMV application used for the payment.
     * @return $this
     */
    public function setApplicationIdentifier($application_identifier)
    {
        $this->application_identifier = $application_identifier;
        return $this;
    }
    /**
     * Gets application_name
     * @return string
     */
    public function getApplicationName()
    {
        return $this->application_name;
    }
  
    /**
     * Sets application_name
     * @param string $application_name For EMV payments, the human-readable name of the EMV application used for the payment.
     * @return $this
     */
    public function setApplicationName($application_name)
    {
        $this->application_name = $application_name;
        return $this;
    }
    /**
     * Gets application_cryptogram
     * @return string
     */
    public function getApplicationCryptogram()
    {
        return $this->application_cryptogram;
    }
  
    /**
     * Sets application_cryptogram
     * @param string $application_cryptogram For EMV payments, the cryptogram generated for the payment.
     * @return $this
     */
    public function setApplicationCryptogram($application_cryptogram)
    {
        $this->application_cryptogram = $application_cryptogram;
        return $this;
    }
    /**
     * Gets verification_method
     * @return string
     */
    public function getVerificationMethod()
    {
        return $this->verification_method;
    }
  
    /**
     * Sets verification_method
     * @param string $verification_method For EMV payments, method used to verify the cardholder's identity.  Can be one of `PIN`, `SIGNATURE`, `PIN_AND_SIGNATURE`, `ON_DEVICE`, or `NONE`.
     * @return $this
     */
    public function setVerificationMethod($verification_method)
    {
        $this->verification_method = $verification_method;
        return $this;
    }
    /**
     * Gets verification_results
     * @return string
     */
    public function getVerificationResults()
    {
        return $this->verification_results;
    }
  
    /**
     * Sets verification_results
     * @param string $verification_results For EMV payments, the results of the cardholder verification.  Can be one of `SUCCESS`, `FAILURE`, or `UNKNOWN`.
     * @return $this
     */
    public function setVerificationResults($verification_results)
    {
        $this->verification_results = $verification_results;
        return $this;
    }
    /**
     * Gets statement_description
     * @return string
     */
    public function getStatementDescription()
    {
        return $this->statement_description;
    }
  
    /**
     * Sets statement_description
     * @param string $statement_description The statement description sent to the card networks.  Note: The actual statement description will vary and is likely to be truncated and appended with additional information on a per issuer basis.
     * @return $this
     */
    public function setStatementDescription($statement_description)
    {
        $this->statement_description = $statement_description;
        return $this;
    }
    /**
     * Gets errors
     * @return \SquareConnect\Model\Error[]
     */
    public function getErrors()
    {
        return $this->errors;
    }
  
    /**
     * Sets errors
     * @param \SquareConnect\Model\Error[] $errors Information on errors encountered during the request.
     * @return $this
     */
    public function setErrors($errors)
    {
        $this->errors = $errors;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
