<?php

// Create a helper function for easy SDK access.
function in_fs()
{
    global  $in_fs ;
    
    if ( !isset( $in_fs ) ) {
        // Include Freemius SDK.
        require_once dirname( __FILE__ ) . '/freemius/start.php';
        $in_fs = fs_dynamic_init( array(
            'id'              => '2034',
            'slug'            => 'NinjaSquareIntegration',
            'type'            => 'plugin',
            'public_key'      => 'pk_957d2e589e10a819bb70a8ac680e7',
            'is_premium'      => true,
            'has_addons'      => false,
            'has_paid_plans'  => true,
            'has_affiliation' => 'selected',
            'menu'            => array(
            'slug'    => 'ninja-square-settings',
            'support' => false,
        ),
            'is_live'         => true,
        ) );
    }
    
    return $in_fs;
}

// Init Freemius.
in_fs();
// Signal that SDK was initiated.
do_action( 'in_fs_loaded' );
function in_fs_custom_connect_message_on_update(
    $message,
    $user_first_name,
    $plugin_title,
    $user_login,
    $site_link,
    $freemius_link
)
{
    return sprintf(
        __( 'Hey %1$s' ) . ',<br>' . __( 'Please help us improve %2$s! If you opt-in, some data about your usage of %2$s will be sent to %5$s. If you skip this, that\'s okay! %2$s will still work just fine.', 'NinjaSquareIntegration' ),
        $user_first_name,
        '<b>' . $plugin_title . '</b>',
        '<b>' . $user_login . '</b>',
        $site_link,
        $freemius_link
    );
}

in_fs()->add_filter(
    'connect_message_on_update',
    'in_fs_custom_connect_message_on_update',
    10,
    6
);