<?php

if (!defined('ABSPATH'))
    exit;

/**
 * Class NF_Square_MergeTags
 */
final class NF_Square_MergeTags extends NF_Abstracts_MergeTags {

    protected $id = 'square';

    public function __construct() {
        parent::__construct();
        $this->title = __('Square', 'ninja-forms');
        $this->merge_tags = $this->config('MergeTags');
    }

    public function __call($name, $arguments) {
        // If the mergetag property is not set, then return an empty string.
        return ( isset($this->$name) ) ? $this->$name : '';
    }

    public function set($property, $value) {
        $this->$property = $value;
    }

    public function config($file_name) {
        return include NINJA_SQUARE_INTEGRATION_PATH . 'includes/config/' . $file_name . '.php';
    }

}

// END CLASS NF_PayPalExpress_MergeTags
