<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
if (!class_exists('Ninja_Square_Settings')) {

    class Ninja_Square_Settings {

        private $options;

        public function __construct() {
            //add setting fields
            add_action('admin_init', array($this, 'square_settings_init'));
            //add option page
            add_action('admin_menu', array($this, 'square_settings_options_page'));
            //show save messages
            add_action('admin_notices', array($this, 'square_settings_admin_notices_action'));
        }
        
        public function square_settings_admin_notices_action(){
            
        }

                /**
         * create sub menu page
         */
        public function square_settings_options_page() {
            add_submenu_page('ninja-forms', __('Square', 'ninja-square'), __('Square', 'ninja-square'), 'manage_options', 'ninja-square-settings', array($this, 'square_setting_options_page_html'));
        }

        /**
         * add option page html
         * @return type
         */
        public function square_setting_options_page_html() {
            // check user capabilities
            if (!current_user_can('manage_options')) {
                return;
            }
            ?>
            <div class="wrap">
                <h1><?php esc_html(get_admin_page_title()); ?></h1>
                <form action="options.php" method="post">
                    <?php
                    // Set class property
                    $this->options = get_option('square_setting_options');
                    settings_fields('square_setting_options_group');
                    do_settings_sections('square-settings-page');
                    submit_button('Save Settings');
                    ?>
                </form>
            </div>
            <?php
        }
        
        /**
         * register option fields
         */
        public function square_settings_init() {
            //
            register_setting('square_setting_options_group', 'square_setting_options', array($this, 'sanitize'));

            add_settings_section('square_setting_section_id', __('Square', 'ninja-square'), '', 'square-settings-page');

            add_settings_field('square_setting_mode', __('Mode', 'ninja-square'), array($this, 'square_setting_mode_callback'), 'square-settings-page', 'square_setting_section_id');
            add_settings_field('square_setting_test_app_id', __('Test Application ID', 'ninja-square'), array($this, 'square_setting_test_app_id_callback'), 'square-settings-page', 'square_setting_section_id');
            add_settings_field('square_setting_test_token', __('Test Token', 'ninja-square'), array($this, 'square_setting_test_token_callback'), 'square-settings-page', 'square_setting_section_id');
            add_settings_field('square_setting_test_location_id', __('Test Location ID', 'ninja-square'), array($this, 'square_setting_test_location_id_callback'), 'square-settings-page', 'square_setting_section_id');
            add_settings_field('square_setting_live_app_id', __('Live Application ID', 'ninja-square'), array($this, 'square_setting_live_app_id_callback'), 'square-settings-page', 'square_setting_section_id', ['class' => 'hidden']);
            add_settings_field('square_setting_live_token', __('Live Token', 'ninja-square'), array($this, 'square_setting_live_token_callback'), 'square-settings-page', 'square_setting_section_id',['class' => 'hidden']);
            add_settings_field('square_auth_btn', __('Square Connect button', 'ninja-square'), array($this, 'square_connect_button'), 'square-settings-page', 'square_setting_section_id');
            
            $options = get_option('square_setting_options');
            if(isset($options['square_setting_btn_auth'])){

                $btn_auth = $options['square_setting_btn_auth'];
            if(!empty($btn_auth) && $btn_auth == 'true'){
                add_settings_field('square_location_dropdown', __('Live Location ID', 'ninja-square'), array($this, 'square_locations_dropdown'), 'square-settings-page', 'square_setting_section_id');
            }

            }
            
            
            
            add_settings_field('square_live_refresh_token', __('Refresh Token', 'ninja-square'), array($this, 'square_live_refresh_token_callback'), 'square-settings-page', 'square_setting_section_id',['class' => 'hidden']);
            add_settings_field('square_setting_expires_at', __('Expires At', 'ninja-square'), array($this, 'square_setting_expires_at_callback'), 'square-settings-page', 'square_setting_section_id',['class' => 'hidden']);
            add_settings_field('square_live_live_locations', __('Live Locations', 'ninja-square'), array($this, 'square_live_live_locations_callback'), 'square-settings-page', 'square_setting_section_id',['class' => 'hidden']);
            add_settings_field('square_setting_btn_auth', __('Auth Button', 'ninja-square'), array($this, 'square_setting_btn_auth_callback'), 'square-settings-page', 'square_setting_section_id',['class' => 'hidden']);
            add_settings_field('square_setting_disconnect_url', __('Disconnect URL', 'ninja-square'), array($this, 'square_setting_disconnect_url_callback'), 'square-settings-page', 'square_setting_section_id',['class' => 'hidden']);
        
            
        }

        /**
         * santize my option fields
         * @param type $input
         * @return type
         */
        public function sanitize($input) {
            $new_input = array();
            if (isset($input['square_setting_mode'])) {
                $new_input['square_setting_mode'] = sanitize_text_field($input['square_setting_mode']);
            }
             if (isset($input['square_setting_test_app_id'])) {
                $new_input['square_setting_test_app_id'] = sanitize_text_field($input['square_setting_test_app_id']);
            }
             if (isset($input['square_setting_test_token'])) {
                $new_input['square_setting_test_token'] = sanitize_text_field($input['square_setting_test_token']);
            }
             if (isset($input['square_setting_test_location_id'])) {
                $new_input['square_setting_test_location_id'] = sanitize_text_field($input['square_setting_test_location_id']);
            }
             if (isset($input['square_setting_live_app_id'])) {
                $new_input['square_setting_live_app_id'] = sanitize_text_field($input['square_setting_live_app_id']);
            }
             if (isset($input['square_setting_live_token'])) {
                $new_input['square_setting_live_token'] = sanitize_text_field($input['square_setting_live_token']);
            }
            if (isset($input['square_setting_live_location_id'])) {
                $new_input['square_setting_live_location_id'] = sanitize_text_field($input['square_setting_live_location_id']);
            }
            if (isset($input['square_live_refresh_token'])) {
                $new_input['square_live_refresh_token'] = sanitize_text_field($input['square_live_refresh_token']);
            }

            if (isset($input['square_setting_expires_at'])) {
                $new_input['square_setting_expires_at'] = sanitize_text_field($input['square_setting_expires_at']);
            }

            if (isset($input['square_live_live_locations'])) {
                $new_input['square_live_live_locations'] = sanitize_text_field($input['square_live_live_locations']);
            }

            if (isset($input['square_setting_btn_auth'])) {
                $new_input['square_setting_btn_auth'] = sanitize_text_field($input['square_setting_btn_auth']);
            }

            if (isset($input['square_setting_disconnect_url'])) {
                $new_input['square_setting_disconnect_url'] = sanitize_text_field($input['square_setting_disconnect_url']);
            }

            
            add_settings_error('gf_wc_setting_fields_updated', esc_attr('gf_wc_setting_fields_updated'), __('Your settings have been saved.', 'ninja-square'), 'updated');

            return $new_input;
        }
        /**
         * show settings error
         */
        function square_setting_admin_notices_action() {
            settings_errors('gf_wc_setting_fields_updated');
        }

        /**
         * all fields callback functions
         */
        public function square_setting_mode_callback() {

            if (!empty($this->options['square_setting_mode'])) {
                $checked = ' checked="checked" ';
            }

            $items = array("Test", "Live");
            foreach ($items as $item) {

                $checked = (@$this->options['square_setting_mode'] == $item) ? ' checked="checked" ' : '';
                echo "<label><input " . $checked . " value='$item' name='square_setting_options[square_setting_mode]' type='radio' /> $item</label> &nbsp &nbsp &nbsp &nbsp &nbsp ";
            }
            echo '<p>' . __('Get square account key from ', 'ninja-square') . '<a href="https://connect.squareup.com/apps" target="_blank">' . __('here', 'ninja-square') . '</a></p>';
        }

        function square_setting_test_app_id_callback() {
            if( empty ($this->options['square_setting_test_app_id'])){
                echo "<input id='square_setting_test_app_id' name='square_setting_options[square_setting_test_app_id]' size='40' type='text' value=' ' />";
            } else {
                echo "<input id='square_setting_test_app_id' name='square_setting_options[square_setting_test_app_id]' size='40' type='text' value='{$this->options['square_setting_test_app_id'] }' />";
            }
        }
        function square_setting_test_token_callback() {
            if( empty ($this->options['square_setting_test_app_id'])){
                echo "<input id='square_setting_test_token' name='square_setting_options[square_setting_test_token]' size='40' type='text' value='' />";
            } else {
                echo "<input id='square_setting_test_token' name='square_setting_options[square_setting_test_token]' size='40' type='text' value='{$this->options['square_setting_test_token']}' />";
            }
        }
        function square_setting_test_location_id_callback() {
            if( empty ($this->options['square_setting_test_app_id'])){
                echo "<input id='square_setting_test_location_id' name='square_setting_options[square_setting_test_location_id]' size='40' type='text' value='' />";
            } else {
                echo "<input id='square_setting_test_location_id' name='square_setting_options[square_setting_test_location_id]' size='40' type='text' value='{$this->options['square_setting_test_location_id']}' />";
            }
        }
        function square_setting_live_app_id_callback() {
            echo "<input id='square_setting_live_app_id' name='square_setting_options[square_setting_live_app_id]' size='40' type='hidden' value='{$this->options['square_setting_live_app_id']}' />";
        }
        function square_setting_live_token_callback() {
            echo "<input id='square_setting_live_token' name='square_setting_options[square_setting_live_token]' size='40' type='hidden' value='{$this->options['square_setting_live_token']}' />";
        }
        
        function square_setting_live_location_id_callback() {
            echo "<input id='square_setting_live_location_id' name='square_setting_options[square_setting_live_location_id]' size='40' type='text' value='{$this->options['square_setting_live_location_id']}' />";
        }

        function square_setting_btn_auth_callback() {
            echo "<input id='square_setting_btn_auth' name='square_setting_options[square_setting_btn_auth]' size='40' type='text' value='{$this->options['square_setting_btn_auth']}' />";
        }

        function square_setting_expires_at_callback() {
            echo "<input id='square_setting_expires_at' name='square_setting_options[square_setting_expires_at]' size='40' type='text' value='{$this->options['square_setting_expires_at']}' />";
        }

        function square_live_refresh_token_callback() {
            echo "<input id='square_live_refresh_token' name='square_setting_options[square_live_refresh_token]' size='40' type='text' value='{$this->options['square_live_refresh_token']}' />";
        }

        function square_live_live_locations_callback() {
            echo "<input id='square_live_live_locations' name='square_setting_options[square_live_live_locations]' size='40' type='text' value='{$this->options['square_live_live_locations']}' />";
        }

        function square_setting_disconnect_url_callback() {
            echo "<input id='square_setting_disconnect_url' name='square_setting_options[square_setting_disconnect_url]' size='40' type='text' value='{$this->options['square_setting_disconnect_url']}' />";
        }

        

        public function square_connect_button(){ 
            $ninja_square_live_token = false;
            $ninja_square_btn_auth = false;
            $ninja_square_disconnect_url = false;

            $options = get_option('square_setting_options');


            if(isset($options['square_setting_live_token']) && $options['square_setting_live_token'] !== ''){

                $ninja_square_live_token = $options['square_setting_live_token'];
            }

            if(isset($options['square_setting_btn_auth']) && $options['square_setting_btn_auth'] !== ''){

                $ninja_square_btn_auth = $options['square_setting_btn_auth'];
            }

            if(isset($options['square_setting_disconnect_url']) && $options['square_setting_disconnect_url'] !== ''){

                $ninja_square_disconnect_url = $options['square_setting_disconnect_url'];
            }
            
            if($ninja_square_btn_auth == false && $ninja_square_live_token !== false){ 
                
                echo '<a a href="' . $this->ninja_create_connect_url() . '" id="ninja_connect_square_btn" class="ninja-square-connect-button"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44 44" width="30" height="30"><path fill="#FFFFFF" d="M36.65 0h-29.296c-4.061 0-7.354 3.292-7.354 7.354v29.296c0 4.062 3.293 7.354 7.354 7.354h29.296c4.062 0 7.354-3.292 7.354-7.354v-29.296c.001-4.062-3.291-7.354-7.354-7.354zm-.646 33.685c0 1.282-1.039 2.32-2.32 2.32h-23.359c-1.282 0-2.321-1.038-2.321-2.32v-23.36c0-1.282 1.039-2.321 2.321-2.321h23.359c1.281 0 2.32 1.039 2.32 2.321v23.36z" /><path fill="#FFFFFF" d="M17.333 28.003c-.736 0-1.332-.6-1.332-1.339v-9.324c0-.739.596-1.339 1.332-1.339h9.338c.738 0 1.332.6 1.332 1.339v9.324c0 .739-.594 1.339-1.332 1.339h-9.338z" /></svg><span>Update with Square</span></a>';                                           
            
            }else if ($ninja_square_btn_auth == false && $ninja_square_live_token == false){
                
                echo '<a href="' . $this->ninja_create_connect_url() . '" id="ninja_connect_square_btn" class="ninja-square-connect-button"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44 44" width="30" height="30"><path fill="#FFFFFF" d="M36.65 0h-29.296c-4.061 0-7.354 3.292-7.354 7.354v29.296c0 4.062 3.293 7.354 7.354 7.354h29.296c4.062 0 7.354-3.292 7.354-7.354v-29.296c.001-4.062-3.291-7.354-7.354-7.354zm-.646 33.685c0 1.282-1.039 2.32-2.32 2.32h-23.359c-1.282 0-2.321-1.038-2.321-2.32v-23.36c0-1.282 1.039-2.321 2.321-2.321h23.359c1.281 0 2.32 1.039 2.32 2.321v23.36z" /><path fill="#FFFFFF" d="M17.333 28.003c-.736 0-1.332-.6-1.332-1.339v-9.324c0-.739.596-1.339 1.332-1.339h9.338c.738 0 1.332.6 1.332 1.339v9.324c0 .739-.594 1.339-1.332 1.339h-9.338z" /></svg><span>Connect with Square</span></a>';          
            
            }else{

                echo '<a href="' . $ninja_square_disconnect_url . '" id="ninja_connect_square_btn" class="ninja-square-connect-button"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44 44" width="30" height="30"><path fill="#FFFFFF" d="M36.65 0h-29.296c-4.061 0-7.354 3.292-7.354 7.354v29.296c0 4.062 3.293 7.354 7.354 7.354h29.296c4.062 0 7.354-3.292 7.354-7.354v-29.296c.001-4.062-3.291-7.354-7.354-7.354zm-.646 33.685c0 1.282-1.039 2.32-2.32 2.32h-23.359c-1.282 0-2.321-1.038-2.321-2.32v-23.36c0-1.282 1.039-2.321 2.321-2.321h23.359c1.281 0 2.32 1.039 2.32 2.321v23.36z" /><path fill="#FFFFFF" d="M17.333 28.003c-.736 0-1.332-.6-1.332-1.339v-9.324c0-.739.596-1.339 1.332-1.339h9.338c.738 0 1.332.6 1.332 1.339v9.324c0 .739-.594 1.339-1.332 1.339h-9.338z" /></svg><span> Disconnect with Square </span></a>';
            }

            // ($ninja_square_btn_auth == true && $ninja_square_live_token == true)

        }

        public function ninja_create_connect_url(){

            $URI_REQUESTED = $_SERVER['REQUEST_URI'];

            /* Fetch GET parameters from URI */
            $parts = parse_url($URI_REQUESTED);
            parse_str($parts['query'], $url_identifiers);
            
            /* Fetch Admin URL */
            $slash_exploded = explode('/', $URI_REQUESTED);
            $question_mark_exploded = explode('?', $slash_exploded[2]);
            $url_identifiers['admin_url'] = $question_mark_exploded[0];
            $url_identifiers['ninja_prepare_connection_call'] = true;

            $connection_url = add_query_arg($url_identifiers, $url_identifiers['admin_url']);
            return $connection_url;

        }

        function square_locations_dropdown(){
            $ninja_square_live_token = false;
            $ninja_square_btn_auth = false;

            $options = get_option('square_setting_options');
            if(isset($options['square_setting_live_token']) && $options['square_setting_live_token'] !== ''){

                $ninja_square_live_token = $options['square_setting_live_token'];
            }

            if(isset($options['square_setting_btn_auth']) && $options['square_setting_btn_auth'] !== ''){

                $ninja_square_btn_auth = $options['square_setting_btn_auth'];

            }

            if($ninja_square_live_token !== false && $ninja_square_btn_auth !== false){
                
                $sqr_settings = get_option('square_setting_options');
                $selected_location = $sqr_settings['square_setting_live_location_id'];
                $locations = $options['square_live_live_locations'];
                $locations = json_decode($locations);
				
                    echo 'selected location is '. get_option('square_setting_options[square_setting_live_location_id]');
                    echo "<select name='square_setting_options[square_setting_live_location_id]'>";
                    foreach($locations as $location){
						foreach($location as $loc){
							if ($selected_location == $loc->id) {
								echo "<option value='". $loc->id ."' selected='selected'>". $loc->name ."</option>";
							} else {
								echo "<option value='". $loc->id ."'>". $loc->name ."</option>";
							}
						}
                    }
                   echo "</select>";             
            }

        }


    }

    $obj = new Ninja_Square_Settings();
}

