<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (!class_exists('Ninja_Square_Core')) {

    class Ninja_Square_Core {

        function __construct() {

				global $in_fs;
			if ( in_fs()->is__premium_only() ) {
				if ( in_fs()->can_use_premium_code() ) {
					add_action('ninja_forms_enqueue_scripts', array($this, 'ninja_square_payment_display_scripts'));
					add_filter('ninja_forms_register_actions', array($this, 'register_new_square_payment_action'), 10, 1);
					add_filter('ninja_forms_register_fields', array($this, 'my_nf_register_fields_filter'), 10, 1);
					add_filter('ninja_forms_field_template_file_paths', array($this, 'my_nf_field_tempalate_file_paths'));
					add_action('ninja_forms_loaded', array($this, 'setup_admin'));
				}
			}
        }

        function register_new_square_payment_action($actions) {
            require_once( NINJA_SQUARE_INTEGRATION_PATH . 'includes/actions/square-payment.php');
            $actions['squarepayment'] = new NF_Actions_SquarePayment();
            return $actions;
        }

        function my_nf_register_fields_filter($fields) {
            require_once( NINJA_SQUARE_INTEGRATION_PATH . 'includes/fields/SquareForm.php');
            $fields['squareform'] = new NF_Fields_SquareForm();
            return $fields;
        }

        function my_nf_field_tempalate_file_paths($file_paths) {
            $file_paths[] = NINJA_SQUARE_INTEGRATION_PATH . 'includes/Templates/';

            return $file_paths;
        }

        /** 
         * enqueue plugin styles and scripts
         */
        function ninja_square_payment_display_scripts($form_id) {
            $form_type = "";
            $id = $form_id["form_id"];
            $form_fields = Ninja_Forms()->form($id)->get_fields();
            foreach ($form_fields as $field) {
                $form = $field->get_settings();
                if ($form['type'] == 'squareform') {
                    $form_type = 'squareform';
                }
            }

            if ($form_type == 'squareform') {

                $options = get_option('square_setting_options');
                $mode_type = $options['square_setting_mode'];
                $test_app_id = $options['square_setting_test_app_id'];
                $test_location_id = $options['square_setting_test_location_id'];
                 
                $live_app_id = $options['square_setting_live_app_id'];
                $live_location_id = isset($options['square_setting_live_location_id']);
                

                if (($mode_type && $test_app_id && $test_location_id) || ($mode_type && $live_app_id && $live_location_id)) {


                    if ($mode_type == 'Test') {
                        wp_enqueue_script('ninja-paymentform', 'https://sandbox.web.squarecdn.com/v1/square.js');
                    }

                    if ($mode_type == 'Live') {
                        wp_enqueue_script('ninja-paymentform', 'https://web.squarecdn.com/v1/square.js');
                    }

                    wp_register_script('ninja-checkout', NINJA_SQUARE_INTEGRATION_URL . 'assets/js/checkout.js?rand='.rand(), array('jquery', 'ninja-paymentform'));
                    wp_localize_script('ninja-checkout', 'ninjacheckout', array(
                        'application_id' => $mode_type == 'Test' ? $test_app_id : $live_app_id,
                        'location_id' => $mode_type == 'Test' ? $test_location_id : $live_location_id,
                        'placeholder_card_number' => __('•••• •••• •••• ••••', 'ninja-square'),
                        'placeholder_card_expiration' => __('MM / YY', 'ninja-square'),
                        'placeholder_card_cvv' => __('CVV', 'ninja-square'),
                        'placeholder_card_postal_code' => __('Card Postal Code', 'ninja-square'),
                        'payment_form_input_styles' => esc_js($this->get_input_styles())
                    ));
                    wp_enqueue_script('ninja-checkout');
                }
                wp_enqueue_style('ninja-square-style', NINJA_SQUARE_INTEGRATION_URL . 'assets/css/custom-style.css');
            }
        }

        /**
         * square form style
         */
        function get_input_styles() {
            $styles = array(
                array(
                    'fontSize' => '16px',
                    'padding' => '0.7em',
                    'backgroundColor' => '#fff'
                )
            );

            return wp_json_encode($styles);
        }

        function setup_admin() {
            require_once( NINJA_SQUARE_INTEGRATION_PATH . 'includes/MergeTags.php');
            require_once( NINJA_SQUARE_INTEGRATION_PATH . 'includes/Admin/Metaboxes/Submission.php');
            Ninja_Forms()->merge_tags['square'] = new NF_Square_MergeTags();
            new NF_Square_Admin_Metaboxes_Submission();
        }

    }

    $obj = new Ninja_Square_Core();
}

            