<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * V1ListTimecardsRequest Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class V1ListTimecardsRequest implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'order' => 'string',
        'employee_id' => 'string',
        'begin_clockin_time' => 'string',
        'end_clockin_time' => 'string',
        'begin_clockout_time' => 'string',
        'end_clockout_time' => 'string',
        'begin_updated_at' => 'string',
        'end_updated_at' => 'string',
        'deleted' => 'bool',
        'limit' => 'int',
        'batch_token' => 'string'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'order' => 'order',
        'employee_id' => 'employee_id',
        'begin_clockin_time' => 'begin_clockin_time',
        'end_clockin_time' => 'end_clockin_time',
        'begin_clockout_time' => 'begin_clockout_time',
        'end_clockout_time' => 'end_clockout_time',
        'begin_updated_at' => 'begin_updated_at',
        'end_updated_at' => 'end_updated_at',
        'deleted' => 'deleted',
        'limit' => 'limit',
        'batch_token' => 'batch_token'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'order' => 'setOrder',
        'employee_id' => 'setEmployeeId',
        'begin_clockin_time' => 'setBeginClockinTime',
        'end_clockin_time' => 'setEndClockinTime',
        'begin_clockout_time' => 'setBeginClockoutTime',
        'end_clockout_time' => 'setEndClockoutTime',
        'begin_updated_at' => 'setBeginUpdatedAt',
        'end_updated_at' => 'setEndUpdatedAt',
        'deleted' => 'setDeleted',
        'limit' => 'setLimit',
        'batch_token' => 'setBatchToken'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'order' => 'getOrder',
        'employee_id' => 'getEmployeeId',
        'begin_clockin_time' => 'getBeginClockinTime',
        'end_clockin_time' => 'getEndClockinTime',
        'begin_clockout_time' => 'getBeginClockoutTime',
        'end_clockout_time' => 'getEndClockoutTime',
        'begin_updated_at' => 'getBeginUpdatedAt',
        'end_updated_at' => 'getEndUpdatedAt',
        'deleted' => 'getDeleted',
        'limit' => 'getLimit',
        'batch_token' => 'getBatchToken'
    );
  
    /**
      * $order The order in which timecards are listed in the response, based on their created_at field. See [SortOrder](#type-sortorder) for possible values
      * @var string
      */
    protected $order;
    /**
      * $employee_id If provided, the endpoint returns only timecards for the employee with the specified ID.
      * @var string
      */
    protected $employee_id;
    /**
      * $begin_clockin_time If filtering results by their clockin_time field, the beginning of the requested reporting period, in ISO 8601 format.
      * @var string
      */
    protected $begin_clockin_time;
    /**
      * $end_clockin_time If filtering results by their clockin_time field, the end of the requested reporting period, in ISO 8601 format.
      * @var string
      */
    protected $end_clockin_time;
    /**
      * $begin_clockout_time If filtering results by their clockout_time field, the beginning of the requested reporting period, in ISO 8601 format.
      * @var string
      */
    protected $begin_clockout_time;
    /**
      * $end_clockout_time If filtering results by their clockout_time field, the end of the requested reporting period, in ISO 8601 format.
      * @var string
      */
    protected $end_clockout_time;
    /**
      * $begin_updated_at If filtering results by their updated_at field, the beginning of the requested reporting period, in ISO 8601 format.
      * @var string
      */
    protected $begin_updated_at;
    /**
      * $end_updated_at If filtering results by their updated_at field, the end of the requested reporting period, in ISO 8601 format.
      * @var string
      */
    protected $end_updated_at;
    /**
      * $deleted If true, only deleted timecards are returned. If false, only valid timecards are returned.If you don't provide this parameter, both valid and deleted timecards are returned.
      * @var bool
      */
    protected $deleted;
    /**
      * $limit The maximum integer number of employee entities to return in a single response. Default 100, maximum 200.
      * @var int
      */
    protected $limit;
    /**
      * $batch_token A pagination cursor to retrieve the next set of results for your original query to the endpoint.
      * @var string
      */
    protected $batch_token;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["order"])) {
              $this->order = $data["order"];
            } else {
              $this->order = null;
            }
            if (isset($data["employee_id"])) {
              $this->employee_id = $data["employee_id"];
            } else {
              $this->employee_id = null;
            }
            if (isset($data["begin_clockin_time"])) {
              $this->begin_clockin_time = $data["begin_clockin_time"];
            } else {
              $this->begin_clockin_time = null;
            }
            if (isset($data["end_clockin_time"])) {
              $this->end_clockin_time = $data["end_clockin_time"];
            } else {
              $this->end_clockin_time = null;
            }
            if (isset($data["begin_clockout_time"])) {
              $this->begin_clockout_time = $data["begin_clockout_time"];
            } else {
              $this->begin_clockout_time = null;
            }
            if (isset($data["end_clockout_time"])) {
              $this->end_clockout_time = $data["end_clockout_time"];
            } else {
              $this->end_clockout_time = null;
            }
            if (isset($data["begin_updated_at"])) {
              $this->begin_updated_at = $data["begin_updated_at"];
            } else {
              $this->begin_updated_at = null;
            }
            if (isset($data["end_updated_at"])) {
              $this->end_updated_at = $data["end_updated_at"];
            } else {
              $this->end_updated_at = null;
            }
            if (isset($data["deleted"])) {
              $this->deleted = $data["deleted"];
            } else {
              $this->deleted = null;
            }
            if (isset($data["limit"])) {
              $this->limit = $data["limit"];
            } else {
              $this->limit = null;
            }
            if (isset($data["batch_token"])) {
              $this->batch_token = $data["batch_token"];
            } else {
              $this->batch_token = null;
            }
        }
    }
    /**
     * Gets order
     * @return string
     */
    public function getOrder()
    {
        return $this->order;
    }
  
    /**
     * Sets order
     * @param string $order The order in which timecards are listed in the response, based on their created_at field. See [SortOrder](#type-sortorder) for possible values
     * @return $this
     */
    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }
    /**
     * Gets employee_id
     * @return string
     */
    public function getEmployeeId()
    {
        return $this->employee_id;
    }
  
    /**
     * Sets employee_id
     * @param string $employee_id If provided, the endpoint returns only timecards for the employee with the specified ID.
     * @return $this
     */
    public function setEmployeeId($employee_id)
    {
        $this->employee_id = $employee_id;
        return $this;
    }
    /**
     * Gets begin_clockin_time
     * @return string
     */
    public function getBeginClockinTime()
    {
        return $this->begin_clockin_time;
    }
  
    /**
     * Sets begin_clockin_time
     * @param string $begin_clockin_time If filtering results by their clockin_time field, the beginning of the requested reporting period, in ISO 8601 format.
     * @return $this
     */
    public function setBeginClockinTime($begin_clockin_time)
    {
        $this->begin_clockin_time = $begin_clockin_time;
        return $this;
    }
    /**
     * Gets end_clockin_time
     * @return string
     */
    public function getEndClockinTime()
    {
        return $this->end_clockin_time;
    }
  
    /**
     * Sets end_clockin_time
     * @param string $end_clockin_time If filtering results by their clockin_time field, the end of the requested reporting period, in ISO 8601 format.
     * @return $this
     */
    public function setEndClockinTime($end_clockin_time)
    {
        $this->end_clockin_time = $end_clockin_time;
        return $this;
    }
    /**
     * Gets begin_clockout_time
     * @return string
     */
    public function getBeginClockoutTime()
    {
        return $this->begin_clockout_time;
    }
  
    /**
     * Sets begin_clockout_time
     * @param string $begin_clockout_time If filtering results by their clockout_time field, the beginning of the requested reporting period, in ISO 8601 format.
     * @return $this
     */
    public function setBeginClockoutTime($begin_clockout_time)
    {
        $this->begin_clockout_time = $begin_clockout_time;
        return $this;
    }
    /**
     * Gets end_clockout_time
     * @return string
     */
    public function getEndClockoutTime()
    {
        return $this->end_clockout_time;
    }
  
    /**
     * Sets end_clockout_time
     * @param string $end_clockout_time If filtering results by their clockout_time field, the end of the requested reporting period, in ISO 8601 format.
     * @return $this
     */
    public function setEndClockoutTime($end_clockout_time)
    {
        $this->end_clockout_time = $end_clockout_time;
        return $this;
    }
    /**
     * Gets begin_updated_at
     * @return string
     */
    public function getBeginUpdatedAt()
    {
        return $this->begin_updated_at;
    }
  
    /**
     * Sets begin_updated_at
     * @param string $begin_updated_at If filtering results by their updated_at field, the beginning of the requested reporting period, in ISO 8601 format.
     * @return $this
     */
    public function setBeginUpdatedAt($begin_updated_at)
    {
        $this->begin_updated_at = $begin_updated_at;
        return $this;
    }
    /**
     * Gets end_updated_at
     * @return string
     */
    public function getEndUpdatedAt()
    {
        return $this->end_updated_at;
    }
  
    /**
     * Sets end_updated_at
     * @param string $end_updated_at If filtering results by their updated_at field, the end of the requested reporting period, in ISO 8601 format.
     * @return $this
     */
    public function setEndUpdatedAt($end_updated_at)
    {
        $this->end_updated_at = $end_updated_at;
        return $this;
    }
    /**
     * Gets deleted
     * @return bool
     */
    public function getDeleted()
    {
        return $this->deleted;
    }
  
    /**
     * Sets deleted
     * @param bool $deleted If true, only deleted timecards are returned. If false, only valid timecards are returned.If you don't provide this parameter, both valid and deleted timecards are returned.
     * @return $this
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;
        return $this;
    }
    /**
     * Gets limit
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }
  
    /**
     * Sets limit
     * @param int $limit The maximum integer number of employee entities to return in a single response. Default 100, maximum 200.
     * @return $this
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;
        return $this;
    }
    /**
     * Gets batch_token
     * @return string
     */
    public function getBatchToken()
    {
        return $this->batch_token;
    }
  
    /**
     * Sets batch_token
     * @param string $batch_token A pagination cursor to retrieve the next set of results for your original query to the endpoint.
     * @return $this
     */
    public function setBatchToken($batch_token)
    {
        $this->batch_token = $batch_token;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
