<?php

if (!defined('ABSPATH'))
    exit;

final class NF_Square_Admin_Metaboxes_Submission extends NF_Abstracts_SubmissionMetabox {

    public function __construct() {
        parent::__construct();

        $this->_title = __('Square Payment', 'ninja-square');
        $this->_context = 'normal';

        if ($this->sub 
            && 
			(!$this->sub->get_extra_value('square_transaction_id') 
			&&  
			!$this->sub->get_extra_value('square_error') 
			)
			
            ) {
            remove_action('add_meta_boxes', array($this, 'add_meta_boxes'));
        }
    }

    public function render_metabox($post, $metabox) {

        echo "<dl>";
		if($this->sub->get_extra_value('square_transaction_id')){
        echo "<dt>";
        echo __("Transaction ID", "ninja-square");
        echo "</dt>";

        echo "<dd>";
        echo $this->sub->get_extra_value('square_transaction_id');
        echo "</dd>";
		}
		if($this->sub->get_extra_value('square_error')){
             echo "<dt>";
                echo __("Square Error", "ninja-square");
                echo "</dt>";
        
                echo "<dd>";
                echo $this->sub->get_extra_value('square_error');
                echo "</dd>";
        echo "</dl>";
    }
	}

}
