<?php

namespace NFMailchimp\NinjaForms\Mailchimp\Endpoints;

// Integrating plugin
use NFMailchimp\NinjaForms\Mailchimp\Handlers\AutogenerateForm;
use NFMailchimp\NinjaForms\Mailchimp\Entities\NfMailchimpResponse;
// Mailchimp
use NFMailchimp\EmailCRM\Mailchimp\RestApi\Responses\Response;
use NFMailchimp\EmailCRM\Mailchimp\Handlers\DiagnoseException;
// REST API
use NFMailchimp\EmailCRM\RestApi\Endpoint;
use NFMailchimp\EmailCRM\RestApi\Contracts\RequestContract;
use NFMailchimp\EmailCRM\RestApi\Contracts\ResponseContract;
use NFMailchimp\EmailCRM\RestApi\Contracts\AuthorizeRequestContract;

/**
 * Endpoint to handle a form autogenerate request
 */
class AutogenerateFormEndpoint extends Endpoint
{

	/**
	 *
	 * @var AutogenerateForm
	 */
	protected $autogenerateForm;

	/**
	 *
	 * @var DiagnoseException
	 */
	protected $diagnoseException;
	
		/**
		 *
		 * @var AuthorizeRequestContract
		 */
		protected $authorizer;
		/**
	 * Set the autogenerate form
	 *
	 * @param AutogenerateForm $autogenerateForm
	 */
	public function setAutogenerateForm($autogenerateForm)
	{
		$this->autogenerateForm = $autogenerateForm;
	}
	/**
	 * Add a DiagnoseException handler
	 * @param DiagnoseException $diagnoseException
	 * @return void
	 */
	public function addDiagnoseException(DiagnoseException $diagnoseException): void
	{
		$this->diagnoseException = $diagnoseException;
	}

	public function addAuthorizer(AuthorizeRequestContract $authorizer)
	{
		$this->authorizer=$authorizer;
	}
	/** @inheritDoc */
	public function getHttpMethod(): string
	{
		return 'POST';
	}

	/** @inheritDoc */
	public function getArgs(): array
	{
		return [
			'listId' => [
				'type' => 'string',
				'required' => true,
			],
			'formTitle' => [
				'type' => 'string',
				'required' => false,
			]
		];
	}

	/** @inheritDoc */
	public function getUri(): string
	{
		return 'nf-autogenerate/';
	}

		/**
		 * Authorize the request
		 *
		 * @param RequestContract $request
		 * @return bool
		 */
	public function authorizeRequest(RequestContract $request): bool
	{
			return $this->authorizer->authorizeRequest($request);
	}

	/** @inheritDoc */
	public function handleRequest(RequestContract $request): ResponseContract
	{

		$listId=$request->getParam('listId');
		
		$formTitle = !is_null($request->getParam('formTitle'))?urldecode($request->getParam('formTitle')):'Mailchimp Autogenerated Form';
		try {
			$this->autogenerateForm->handle($listId, $formTitle);
			$formId=$this->autogenerateForm->getFormId();
			$response = NfMailchimpResponse::fromArray(
				[
									'data'=>['formId'=>$formId],
									'status'=>200
								]
			);
						wp_redirect(admin_url().'?page=ninja-forms&form_id='.$formId);
			exit();

			return $response;
		} catch (\Exception $exception) {
			$response = $this->constructExceptionResponse($exception, 'AutogenerateForm');
			return $response;
		}
	}

	/**
	 * Construct exception response from given exception
	 * @param \Exception $exception
	 * @param string $context
	 * @return Response
	 */
	protected function constructExceptionResponse($exception, string $context = ''): ResponseContract
	{
		$response = new NfMailchimpResponse();
		$exceptionString = $exception->getMessage();

		if (isset($this->diagnoseException)) {
			$diagnostics = $this->diagnoseException->handle($exceptionString, $context);
		} else {
			$diagnostics = [];
		}

		$data = [
			'message' => $exceptionString,
			'context' => $context,
			'diagnostics' => $diagnostics
		];

		$response->setData($data);

		$response->setStatus($exception->getCode() ? (int)$exception->getCode() : 500);
		return $response;
	}
}
