import {
  login,
  activatePlugin,
  publishFormWithVerify,
  setFormTitle,
} from "../support/util";

import {
  buttonClickByTitle,
  textboxValueById,
} from "../support/util-inputs";

import {
  buttonClickByActionType,
  createNewForm,
  goToEmailsActionsTab,
} from "../support/util-nf";


/**
 * Tests for adding plugin action
 */
describe("Ensure plugin action can be created and published", () => {
  it("logs in and activates the plugin and Ninja Forms", () => {
    login();
    activatePlugin("ninja-forms");
    activatePlugin("ninja-forms-mail-chimp");
  });

  /**
   * Edit contact form to add action
   */
  it("creates a new form", () => {
    createNewForm();
    setFormTitle("Verify adding action");
  });

  it("adds a new `Add to` plugin action", () => {
    goToEmailsActionsTab();
    buttonClickByTitle("Add new action");
    buttonClickByActionType("mailchimp");

    const newTextboxValue = "My first Mailchimp action";
    cy.wait(500);

    textboxValueById("label", newTextboxValue);

    buttonClickByTitle("Done");
    cy.wait(500);

    publishFormWithVerify();
  });
});
