import { login, activatePlugin, activateLicense } from "../support/util";


/**
 * Before tests, login
 *
 * This is an anti-pattern
 * @todo Use wp-cli or basic authentication headers
 */
before(() => {});

/**
 * Tests ensuring Ninja Forms is properly loaded
 */
describe("Ensure that plugin licensing is functional", () => {
  it("logs into the site and activates Ninja Forms", () => {
    login();
    activatePlugin("ninja-forms");
  });

  // Skip license test until license issue resolved
  it("adds license", () => {
    activateLicense("mail-chimp", Cypress.env('mailchimpLicenseKey'));
    cy.contains("De-activate");
  });
});
