import {
  login,
  activatePlugin,
} from "../support/util";

import {
  textboxValueByName,
} from "../support/util-inputs";

import {
  goToNfSettingsPage,
  saveNfSettings,
} from "../support/util-nf";

/**
 * Tests for retrieving ConvertKit fields
 */
describe("Ensure NF Settings page displays correctly", () => {
  it("logs in and activates the plugin and Ninja Forms", () => {
    login();
    activatePlugin("ninja-forms");
    activatePlugin("ninja-forms-mail-chimp");
  });

  it("visits the NF Settings page", () => {
    goToNfSettingsPage();
  });
});

describe("Ensures credentials can be entered and saved", () => {

  it("enters API Key", () => {
    textboxValueByName("ninja_forms[ninja_forms_mc_api]", Cypress.env('mailchimpApiKey'));
    saveNfSettings();
 
  });

});
