<?php

$posts = [
    '-' => []
];

foreach ($args['product_posts'] as $p) {

    $terms = wp_get_post_terms($p->ID, 'product-category');
    if (empty($terms)) {
        $posts['-'][] = $p;
    }

    foreach ($terms as $t) {
        $key = $t->name;
        $posts[$key] = $posts[$key] ?: [];
        $posts[$key][] = $p;
    }
}

?>
<div id="product-plugin" class="product-page">
    <?php foreach ($posts as $cat_name => $cat_products): ?>

        <div class="product-section">
            <?php if ($cat_name !== '-'): ?>
                <h2><?= $cat_name ?></h2>
            <?php endif; ?>
            <div class="product-listing">
                <?php foreach($cat_products as $p): ?>
                    <a class="product" href="<?= get_the_permalink($p->ID) ?>">
                        <?= get_the_post_thumbnail($p->ID) ?>
                        <h5><?= $p->post_title ?></h5>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>

    <?php endforeach; ?>
</div>