<?php

namespace LAP_Plugin;

class ShortCode
{

    public function __construct()
    {
        add_shortcode('product-listing', [$this, 'product_listing']);
    }

    public function product_listing($user_attributes)
    {
        $default_attributes = [
            'cat' => ''
        ];

        $options = shortcode_atts($default_attributes, $user_attributes);

        $query_options = [
            'numberposts' => -1,
            'post_type'   => 'product',
        ];

        if ($options['cat']) {
            $query_options['tax_query'][] = [
                'taxonomy' => 'product-category',
                'field' => 'slug'
            ];
        }

        $product_posts = get_posts($query_options);
        
        ob_start();

        load_template(
            dirname(__DIR__).'/templates/product_listing.php',
            true,
            [
                'product_posts' => $product_posts,
                'category' => $options['cat']
            ]
        );

        return ob_get_clean();
    }
}

new ShortCode();