<?php

namespace LAP_Plugin;

class PostTypes
{

    public function __construct()
    {
        add_action('init', [$this, 'add_post_type']);
        add_action('init', [$this, 'add_fields']);
        add_action('init', [$this, 'add_options_fields']);
        add_action('init', [$this, 'add_taxonomy']);
        add_filter('single_template', [$this, 'custom_template']);
    }

    function custom_template($single)
    {

        global $post;

        if ($post->post_type === 'product') {
            $single = dirname(__DIR__) . '/templates/single-product.php';
        }

        return $single;
    }

    public function add_post_type()
    {

        $labels = [
            'name' => 'Products',
            'singular_name' => 'Product',
            'menu_name' => 'Products',
            'all_items' => 'All Products',
            'edit_item' => 'Edit Product',
            'view_item' => 'View Product',
            'view_items' => 'View Products',
            'add_new_item' => 'Add New Product',
            'add_new' => 'Add New Product',
            'new_item' => 'New Product',
            'parent_item_colon' => 'Parent Product:',
            'search_items' => 'Search Products',
            'not_found' => 'No products found',
            'not_found_in_trash' => 'No products found in Trash',
            'archives' => 'Product Archives',
            'attributes' => 'Product Attributes',
            'insert_into_item' => 'Insert into product',
            'uploaded_to_this_item' => 'Uploaded to this product',
            'filter_items_list' => 'Filter products list',
            'filter_by_date' => 'Filter products by date',
            'items_list_navigation' => 'Products list navigation',
            'items_list' => 'Products list',
            'item_published' => 'Product published.',
            'item_published_privately' => 'Product published privately.',
            'item_reverted_to_draft' => 'Product reverted to draft.',
            'item_scheduled' => 'Product scheduled.',
            'item_updated' => 'Product updated.',
            'item_link' => 'Product Link',
            'item_link_description' => 'A link to a product.',
        ];

        register_post_type('product', [
            'labels' => $labels,
            'public' => true,
            'show_in_rest' => true,
            'menu_icon' => 'dashicons-tag',
            'supports' => [
                0 => 'title',
                1 => 'editor',
                2 => 'thumbnail',
                3 => 'custom-fields',
            ],
            'delete_with_user' => false,
        ]);
    }

    public function add_fields()
    {
        acf_add_local_field_group([
            'key' => 'group_67c1de4c00629',
            'title' => 'Products',
            'fields' => array(
                array(
                    'key' => 'field_67c1de4ce1325',
                    'label' => 'Part ID',
                    'name' => 'part_id',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'allow_in_bindings' => 0,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_67c1ded0e1326',
                    'label' => 'Dimensions',
                    'name' => 'dimensions',
                    'aria-label' => '',
                    'type' => 'checkbox',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'L' => 'L',
                        'W' => 'W',
                        'DIA' => 'DIA',
                        'INS' => 'INS',
                        'LEG' => 'LEG',
                        'S' => 'S',
                        'T' => 'T',
                        'A' => 'A',
                        'B' => 'B',
                        'OD' => 'OD',
                        'ID' => 'ID',
                        'R1' => 'R1',
                    ),
                    'default_value' => array(),
                    'return_format' => 'array',
                    'allow_custom' => 0,
                    'allow_in_bindings' => 0,
                    'layout' => 'vertical',
                    'toggle' => 0,
                    'save_custom' => 0,
                    'custom_choice_button_text' => 'Add new choice',
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'product',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ]);
    }


    public function add_options_fields()
    {
        acf_add_local_field_group([
            'key' => 'group_659728379123864',
            'title' => 'Products Page',
            'fields' => array(
                array(
                    'key' => 'field_285699e9e93b7',
                    'label' => 'Form Shortcode',
                    'name' => 'product_form_shortcode',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                )
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => 'lionshead-settings',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ]);
    }


    public function add_taxonomy()
    {

        $labels = [
            'name' => 'Product Categories',
            'singular_name' => 'Product Category',
            'menu_name' => 'Product Categories',
            'all_items' => 'All Product Categories',
            'edit_item' => 'Edit Product Category',
            'view_item' => 'View Product Category',
            'update_item' => 'Update Product Category',
            'add_new_item' => 'Add New Product Category',
            'new_item_name' => 'New Product Category Name',
            'search_items' => 'Search Product Categories',
            'popular_items' => 'Popular Product Categories',
            'separate_items_with_commas' => 'Separate product categories with commas',
            'add_or_remove_items' => 'Add or remove product categories',
            'choose_from_most_used' => 'Choose from the most used product categories',
            'not_found' => 'No product categories found',
            'no_terms' => 'No product categories',
            'items_list_navigation' => 'Product Categories list navigation',
            'items_list' => 'Product Categories list',
            'back_to_items' => '← Go to product categories',
            'item_link' => 'Product Category Link',
            'item_link_description' => 'A link to a product category',
        ];

        $options = [
            'labels' => $labels,
            'public' => true,
            'publicly_queryable' => false,
            'show_in_menu' => true,
            'show_in_rest' => false,
            'show_tagcloud' => false,
            'show_admin_column' => true
        ];

        register_taxonomy('product-category', [0 => 'product'], $options);
    }

}

new PostTypes();