<?php

declare(strict_types=1);

namespace Square\Models;

/**
 * Request object for the [ListMerchant](#endpoint-listmerchant) endpoint.
 */
class ListMerchantsRequest implements \JsonSerializable
{
    /**
     * @var int|null
     */
    private $cursor;

    /**
     * Returns Cursor.
     *
     * The cursor generated by the previous response.
     */
    public function getCursor(): ?int
    {
        return $this->cursor;
    }

    /**
     * Sets Cursor.
     *
     * The cursor generated by the previous response.
     *
     * @maps cursor
     */
    public function setCursor(?int $cursor): void
    {
        $this->cursor = $cursor;
    }

    /**
     * Encode this object to JSON
     *
     * @return mixed
     */
    public function jsonSerialize()
    {
        $json = [];
        $json['cursor'] = $this->cursor;

        return array_filter($json, function ($val) {
            return $val !== null;
        });
    }
}
