## Terminal Checkout

### Structure

`TerminalCheckout`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `id` | `?string` | Optional | A unique ID for this `TerminalCheckout` |
| `amountMoney` | [`Money`](/doc/models/money.md) |  | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `referenceId` | `?string` | Optional | An optional user-defined reference ID which can be used to associate<br>this TerminalCheckout to another entity in an external system. For example, an order<br>ID generated by a third-party shopping cart. Will also be associated with any payments<br>used to complete the checkout. |
| `note` | `?string` | Optional | An optional note to associate with the checkout, as well any payments used to complete the checkout. |
| `deviceOptions` | [`DeviceCheckoutOptions`](/doc/models/device-checkout-options.md) |  | -  |
| `deadlineDuration` | `?string` | Optional | The duration as an RFC 3339 duration, after which the checkout will be automatically canceled.<br>TerminalCheckouts that are PENDING will be automatically CANCELED and have a cancellation reason<br>of “TIMED\_OUT”.<br><br>Default: 5 minutes from creation<br><br>Maximum: 5 minutes |
| `status` | `?string` | Optional | The status of the `TerminalCheckout`.<br>Options: PENDING, IN\_PROGRESS, CANCELED, COMPLETED |
| `cancelReason` | [`?string (TerminalCheckoutCancelReason)`](/doc/models/terminal-checkout-cancel-reason.md) | Optional | -  |
| `paymentIds` | `?(string[])` | Optional | A list of payments created by this `TerminalCheckout`. |
| `createdAt` | `?string` | Optional | The time when the `TerminalCheckout` was created as an RFC 3339 timestamp. |
| `updatedAt` | `?string` | Optional | The time when the `TerminalCheckout` was last updated as an RFC 3339 timestamp. |

### Example (as JSON)

```json
{
  "id": null,
  "amount_money": {
    "amount": null,
    "currency": null
  },
  "reference_id": null,
  "note": null,
  "device_options": {
    "device_id": "device_id6",
    "skip_receipt_screen": null,
    "tip_settings": null
  },
  "deadline_duration": null,
  "status": null,
  "cancel_reason": null,
  "payment_ids": null,
  "created_at": null,
  "updated_at": null
}
```

