## Payment

Represents a payment processed by the Square API.

### Structure

`Payment`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `id` | `?string` | Optional | Unique ID for the payment. |
| `createdAt` | `?string` | Optional | Timestamp of when the payment was created, in RFC 3339 format. |
| `updatedAt` | `?string` | Optional | Timestamp of when the payment was last updated, in RFC 3339 format. |
| `amountMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `tipMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `totalMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `appFeeMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `processingFee` | [`?(ProcessingFee[])`](/doc/models/processing-fee.md) | Optional | Processing fees and fee adjustments assessed by Square on this payment. |
| `refundedMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `status` | `?string` | Optional | Indicates whether the payment is `APPROVED`, `COMPLETED`, `CANCELED`, or `FAILED`. |
| `delayDuration` | `?string` | Optional | The duration of time after the payment's creation when Square automatically applies the<br>`delay_action` to the payment. This automatic `delay_action` applies only to payments that<br>don't reach a terminal state (COMPLETED, CANCELED, or FAILED) before the `delay_duration`<br>time period.<br><br>This field is specified as a time duration, in RFC 3339 format.<br><br>Notes:<br>This feature is only supported for card payments.<br><br>Default:<br><br>- Card Present payments: "PT36H" (36 hours) from the creation time.<br>- Card Not Present payments: "P7D" (7 days) from the creation time. |
| `delayAction` | `?string` | Optional | The action to be applied to the payment when the `delay_duration` has elapsed. This field<br>is read only.<br><br>Current values include:<br>`CANCEL` |
| `delayedUntil` | `?string` | Optional | Read only timestamp of when the `delay_action` will automatically be applied,<br>in RFC 3339 format.<br><br>Note that this field is calculated by summing the payment's `delay_duration` and `created_at`<br>fields. The `created_at` field is generated by Square and may not exactly match the<br>time on your local machine. |
| `sourceType` | `?string` | Optional | The source type for this payment<br><br>Current values include: `CARD`. |
| `cardDetails` | [`?CardPaymentDetails`](/doc/models/card-payment-details.md) | Optional | Reflects the current status of a card payment. |
| `locationId` | `?string` | Optional | ID of the location associated with the payment. |
| `orderId` | `?string` | Optional | ID of the order associated with this payment. |
| `referenceId` | `?string` | Optional | An optional ID that associates this payment with an entity in<br>another system. |
| `customerId` | `?string` | Optional | The [Customer](#type-customer) ID of the customer associated with the payment. |
| `employeeId` | `?string` | Optional | An optional ID of the employee associated with taking this payment. |
| `refundIds` | `?(string[])` | Optional | List of `refund_id`s identifying refunds for this payment. |
| `buyerEmailAddress` | `?string` | Optional | The buyer's e-mail address |
| `billingAddress` | [`?Address`](/doc/models/address.md) | Optional | Represents a physical address. |
| `shippingAddress` | [`?Address`](/doc/models/address.md) | Optional | Represents a physical address. |
| `note` | `?string` | Optional | An optional note to include when creating a payment |
| `statementDescriptionIdentifier` | `?string` | Optional | Additional payment information that gets added on the customer's card statement<br>as part of the statement description.<br><br>Note that the `statement_description_identifier` may get truncated on the statement description<br>to fit the required information including the Square identifier (SQ *) and name of the<br>merchant taking the payment. |
| `receiptNumber` | `?string` | Optional | The payment's receipt number.<br>The field will be missing if a payment is CANCELED |
| `receiptUrl` | `?string` | Optional | The URL for the payment's receipt.<br>The field will only be populated for COMPLETED payments. |

### Example (as JSON)

```json
{
  "id": null,
  "created_at": null,
  "updated_at": null,
  "amount_money": null,
  "tip_money": null,
  "total_money": null,
  "app_fee_money": null,
  "processing_fee": null,
  "refunded_money": null,
  "status": null,
  "delay_duration": null,
  "delay_action": null,
  "delayed_until": null,
  "source_type": null,
  "card_details": null,
  "location_id": null,
  "order_id": null,
  "reference_id": null,
  "customer_id": null,
  "employee_id": null,
  "refund_ids": null,
  "buyer_email_address": null,
  "billing_address": null,
  "shipping_address": null,
  "note": null,
  "statement_description_identifier": null,
  "receipt_number": null,
  "receipt_url": null
}
```

