## Order

Contains all information related to a single order to process with Square,
including line items that specify the products to purchase. Order objects also
include information on any associated tenders, refunds, and returns.

All Connect V2 Transactions have all been converted to Orders including all associated
itemization data.

### Structure

`Order`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `id` | `?string` | Optional | The order's unique ID. |
| `locationId` | `string` |  | The ID of the merchant location this order is associated with. |
| `referenceId` | `?string` | Optional | A client specified identifier to associate an entity in another system<br>with this order. |
| `source` | [`?OrderSource`](/doc/models/order-source.md) | Optional | Represents the origination details of an order. |
| `customerId` | `?string` | Optional | The [Customer](#type-customer) ID of the customer associated with the order. |
| `lineItems` | [`?(OrderLineItem[])`](/doc/models/order-line-item.md) | Optional | The line items included in the order. |
| `taxes` | [`?(OrderLineItemTax[])`](/doc/models/order-line-item-tax.md) | Optional | The list of all taxes associated with the order.<br><br>Taxes can be scoped to either `ORDER` or `LINE_ITEM`. For taxes with `LINE_ITEM` scope, an<br>`OrderLineItemAppliedTax` must be added to each line item that the tax applies to. For taxes<br>with `ORDER` scope, the server will generate an `OrderLineItemAppliedTax` for every line item.<br><br>On reads, each tax in the list will include the total amount of that tax applied to the order.<br><br>__IMPORTANT__: If `LINE_ITEM` scope is set on any taxes in this field, usage of the deprecated<br>`line_items.taxes` field will result in an error. Please use `line_items.applied_taxes`<br>instead. |
| `discounts` | [`?(OrderLineItemDiscount[])`](/doc/models/order-line-item-discount.md) | Optional | The list of all discounts associated with the order.<br><br>Discounts can be scoped to either `ORDER` or `LINE_ITEM`. For discounts scoped to `LINE_ITEM`,<br>an `OrderLineItemAppliedDiscount` must be added to each line item that the discount applies to.<br>For discounts with `ORDER` scope, the server will generate an `OrderLineItemAppliedDiscount`<br>for every line item.<br><br>__IMPORTANT__: If `LINE_ITEM` scope is set on any discounts in this field, usage of the deprecated<br>`line_items.discounts` field will result in an error. Please use `line_items.applied_discounts`<br>instead. |
| `serviceCharges` | [`?(OrderServiceCharge[])`](/doc/models/order-service-charge.md) | Optional | A list of service charges applied to the order. |
| `fulfillments` | [`?(OrderFulfillment[])`](/doc/models/order-fulfillment.md) | Optional | Details on order fulfillment.<br><br>Orders can only be created with at most one fulfillment. However, orders returned<br>by the API may contain multiple fulfillments. |
| `returns` | [`?(OrderReturn[])`](/doc/models/order-return.md) | Optional | Collection of items from sale Orders being returned in this one. Normally part of an<br>Itemized Return or Exchange.  There will be exactly one `Return` object per sale Order being<br>referenced. |
| `returnAmounts` | [`?OrderMoneyAmounts`](/doc/models/order-money-amounts.md) | Optional | A collection of various money amounts. |
| `netAmounts` | [`?OrderMoneyAmounts`](/doc/models/order-money-amounts.md) | Optional | A collection of various money amounts. |
| `roundingAdjustment` | [`?OrderRoundingAdjustment`](/doc/models/order-rounding-adjustment.md) | Optional | A rounding adjustment of the money being returned. Commonly used to apply Cash Rounding<br>when the minimum unit of account is smaller than the lowest physical denomination of currency. |
| `tenders` | [`?(Tender[])`](/doc/models/tender.md) | Optional | The Tenders which were used to pay for the Order. |
| `refunds` | [`?(Refund[])`](/doc/models/refund.md) | Optional | The Refunds that are part of this Order. |
| `metadata` | `?array` | Optional | Application-defined data attached to this order. Metadata fields are intended<br>to store descriptive references or associations with an entity in another system or store brief<br>information about the object. Square does not process this field; it only stores and returns it<br>in relevant API calls. Do not use metadata to store any sensitive information (personally<br>identifiable information, card details, etc.).<br><br>Keys written by applications must be 60 characters or less and must be in the character set<br>`[a-zA-Z0-9_-]`. Entries may also include metadata generated by Square. These keys are prefixed<br>with a namespace, separated from the key with a ':' character.<br><br>Values have a max length of 255 characters.<br><br>An application may have up to 10 entries per metadata field.<br><br>Entries written by applications are private and can only be read or modified by the same<br>application.<br><br>See [Metadata](https://developer.squareup.com/docs/build-basics/metadata) for more information. |
| `createdAt` | `?string` | Optional | Timestamp for when the order was created. In RFC 3339 format, e.g., "2016-09-04T23:59:33.123Z". |
| `updatedAt` | `?string` | Optional | Timestamp for when the order was last updated. In RFC 3339 format, e.g., "2016-09-04T23:59:33.123Z". |
| `closedAt` | `?string` | Optional | Timestamp for when the order reached a terminal [state](#property-state). In RFC 3339 format, e.g., "2016-09-04T23:59:33.123Z". |
| `state` | [`?string (OrderState)`](/doc/models/order-state.md) | Optional | The state of the order. |
| `version` | `?int` | Optional | Version number which is incremented each time an update is committed to the order.<br>Orders that were not created through the API will not include a version and<br>thus cannot be updated.<br><br>[Read more about working with versions](https://developer.squareup.com/docs/orders-api/manage-orders#update-orders). |
| `totalMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `totalTaxMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `totalDiscountMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `totalServiceChargeMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `rewards` | [`?(OrderReward[])`](/doc/models/order-reward.md) | Optional | A set-like list of rewards that have been added to the order. |

### Example (as JSON)

```json
{
  "id": null,
  "location_id": "location_id4",
  "reference_id": null,
  "source": null,
  "customer_id": null,
  "line_items": null,
  "taxes": null,
  "discounts": null,
  "service_charges": null,
  "fulfillments": null,
  "returns": null,
  "return_amounts": null,
  "net_amounts": null,
  "rounding_adjustment": null,
  "tenders": null,
  "refunds": null,
  "metadata": null,
  "created_at": null,
  "updated_at": null,
  "closed_at": null,
  "state": null,
  "version": null,
  "total_money": null,
  "total_tax_money": null,
  "total_discount_money": null,
  "total_service_charge_money": null,
  "rewards": null
}
```

