## Order Line Item

Represents a line item in an order. Each line item describes a different
product to purchase, with its own quantity and price details.

### Structure

`OrderLineItem`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `uid` | `?string` | Optional | Unique ID that identifies the line item only within this order. |
| `name` | `?string` | Optional | The name of the line item. |
| `quantity` | `string` |  | The quantity purchased, formatted as a decimal number.<br>For example: `"3"`.<br><br>Line items with a `quantity_unit` can have non-integer quantities.<br>For example: `"1.70000"`. |
| `quantityUnit` | [`?OrderQuantityUnit`](/doc/models/order-quantity-unit.md) | Optional | Contains the measurement unit for a quantity and a precision which<br>specifies the number of digits after the decimal point for decimal quantities. |
| `note` | `?string` | Optional | The note of the line item. |
| `catalogObjectId` | `?string` | Optional | The [CatalogItemVariation](#type-catalogitemvariation) id applied to this line item. |
| `variationName` | `?string` | Optional | The name of the variation applied to this line item. |
| `metadata` | `?array` | Optional | Application-defined data attached to this line item. Metadata fields are intended<br>to store descriptive references or associations with an entity in another system or store brief<br>information about the object. Square does not process this field; it only stores and returns it<br>in relevant API calls. Do not use metadata to store any sensitive information (personally<br>identifiable information, card details, etc.).<br><br>Keys written by applications must be 60 characters or less and must be in the character set<br>`[a-zA-Z0-9_-]`. Entries may also include metadata generated by Square. These keys are prefixed<br>with a namespace, separated from the key with a ':' character.<br><br>Values have a max length of 255 characters.<br><br>An application may have up to 10 entries per metadata field.<br><br>Entries written by applications are private and can only be read or modified by the same<br>application.<br><br>See [Metadata](https://developer.squareup.com/docs/build-basics/metadata) for more information. |
| `modifiers` | [`?(OrderLineItemModifier[])`](/doc/models/order-line-item-modifier.md) | Optional | The [CatalogModifier](#type-catalogmodifier)s applied to this line item. |
| `appliedTaxes` | [`?(OrderLineItemAppliedTax[])`](/doc/models/order-line-item-applied-tax.md) | Optional | The list of references to taxes applied to this line item. Each<br>`OrderLineItemAppliedTax` has a `tax_uid` that references the `uid` of a<br>top-level `OrderLineItemTax` applied to the line item. On reads, the<br>amount applied is populated.<br><br>An `OrderLineItemAppliedTax` will be automatically created on every line<br>item for all `ORDER` scoped taxes added to the order. `OrderLineItemAppliedTax`<br>records for `LINE_ITEM` scoped taxes must be added in requests for the tax<br>to apply to any line items.<br><br>To change the amount of a tax, modify the referenced top-level tax. |
| `appliedDiscounts` | [`?(OrderLineItemAppliedDiscount[])`](/doc/models/order-line-item-applied-discount.md) | Optional | The list of references to discounts applied to this line item. Each<br>`OrderLineItemAppliedDiscount` has a `discount_uid` that references the `uid` of a top-level<br>`OrderLineItemDiscounts` applied to the line item. On reads, the amount<br>applied is populated.<br><br>An `OrderLineItemAppliedDiscount` will be automatically created on every line item for all<br>`ORDER` scoped discounts that are added to the order. `OrderLineItemAppliedDiscount` records<br>for `LINE_ITEM` scoped discounts must be added in requests for the discount to apply to any<br>line items.<br><br>To change the amount of a discount, modify the referenced top-level discount. |
| `basePriceMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `variationTotalPriceMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `grossSalesMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `totalTaxMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `totalDiscountMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `totalMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |

### Example (as JSON)

```json
{
  "uid": null,
  "name": null,
  "quantity": "quantity6",
  "quantity_unit": null,
  "note": null,
  "catalog_object_id": null,
  "variation_name": null,
  "metadata": null,
  "modifiers": null,
  "applied_taxes": null,
  "applied_discounts": null,
  "base_price_money": null,
  "variation_total_price_money": null,
  "gross_sales_money": null,
  "total_tax_money": null,
  "total_discount_money": null,
  "total_money": null
}
```

