## Order Line Item Discount

Represents a discount that applies to one or more line items in an
order.

Fixed-amount, order-scoped discounts are distributed across all non-zero line item totals.
The amount distributed to each line item is relative to the
amount contributed by the item to the order subtotal.

### Structure

`OrderLineItemDiscount`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `uid` | `?string` | Optional | Unique ID that identifies the discount only within this order. |
| `catalogObjectId` | `?string` | Optional | The catalog object id referencing [CatalogDiscount](#type-catalogdiscount). |
| `name` | `?string` | Optional | The discount's name. |
| `type` | [`?string (OrderLineItemDiscountType)`](/doc/models/order-line-item-discount-type.md) | Optional | Indicates how the discount is applied to the associated line item or order. |
| `percentage` | `?string` | Optional | The percentage of the discount, as a string representation of a decimal number.<br>A value of `7.25` corresponds to a percentage of 7.25%.<br><br>`percentage` is not set for amount-based discounts. |
| `amountMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `appliedMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `metadata` | `?array` | Optional | Application-defined data attached to this discount. Metadata fields are intended<br>to store descriptive references or associations with an entity in another system or store brief<br>information about the object. Square does not process this field; it only stores and returns it<br>in relevant API calls. Do not use metadata to store any sensitive information (personally<br>identifiable information, card details, etc.).<br><br>Keys written by applications must be 60 characters or less and must be in the character set<br>`[a-zA-Z0-9_-]`. Entries may also include metadata generated by Square. These keys are prefixed<br>with a namespace, separated from the key with a ':' character.<br><br>Values have a max length of 255 characters.<br><br>An application may have up to 10 entries per metadata field.<br><br>Entries written by applications are private and can only be read or modified by the same<br>application.<br><br>See [Metadata](https://developer.squareup.com/docs/build-basics/metadata) for more information. |
| `scope` | [`?string (OrderLineItemDiscountScope)`](/doc/models/order-line-item-discount-scope.md) | Optional | Indicates whether this is a line item or order level discount. |
| `rewardIds` | `?(string[])` | Optional | The reward identifiers corresponding to this discount. The application and<br>specification of discounts that have `reward_ids` are completely controlled by the backing<br>criteria corresponding to the reward tiers of the rewards that are added to the order<br>through the Loyalty API. To manually unapply discounts that are the result of added rewards,<br>the rewards must be removed from the order through the Loyalty API. |

### Example (as JSON)

```json
{
  "uid": null,
  "catalog_object_id": null,
  "name": null,
  "type": null,
  "percentage": null,
  "amount_money": null,
  "applied_money": null,
  "metadata": null,
  "scope": null,
  "reward_ids": null
}
```

