## Order Fulfillment

Contains details on how to fulfill this order.

### Structure

`OrderFulfillment`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `uid` | `?string` | Optional | Unique ID that identifies the fulfillment only within this order. |
| `type` | [`?string (OrderFulfillmentType)`](/doc/models/order-fulfillment-type.md) | Optional | The type of fulfillment. |
| `state` | [`?string (OrderFulfillmentState)`](/doc/models/order-fulfillment-state.md) | Optional | The current state of this fulfillment. |
| `metadata` | `?array` | Optional | Application-defined data attached to this fulfillment. Metadata fields are intended<br>to store descriptive references or associations with an entity in another system or store brief<br>information about the object. Square does not process this field; it only stores and returns it<br>in relevant API calls. Do not use metadata to store any sensitive information (personally<br>identifiable information, card details, etc.).<br><br>Keys written by applications must be 60 characters or less and must be in the character set<br>`[a-zA-Z0-9_-]`. Entries may also include metadata generated by Square. These keys are prefixed<br>with a namespace, separated from the key with a ':' character.<br><br>Values have a max length of 255 characters.<br><br>An application may have up to 10 entries per metadata field.<br><br>Entries written by applications are private and can only be read or modified by the same<br>application.<br><br>See [Metadata](https://developer.squareup.com/docs/build-basics/metadata) for more information. |
| `pickupDetails` | [`?OrderFulfillmentPickupDetails`](/doc/models/order-fulfillment-pickup-details.md) | Optional | Contains details necessary to fulfill a pickup order. |
| `shipmentDetails` | [`?OrderFulfillmentShipmentDetails`](/doc/models/order-fulfillment-shipment-details.md) | Optional | Contains details necessary to fulfill a shipment order. |

### Example (as JSON)

```json
{
  "uid": null,
  "type": null,
  "state": null,
  "metadata": null,
  "pickup_details": null,
  "shipment_details": null
}
```

