## Inventory Adjustment

Represents a change in state or quantity of product inventory at a
particular time and location.

### Structure

`InventoryAdjustment`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `id` | `?string` | Optional | A unique ID generated by Square for the<br>`InventoryAdjustment`. |
| `referenceId` | `?string` | Optional | An optional ID provided by the application to tie the<br>`InventoryAdjustment` to an external<br>system. |
| `fromState` | [`?string (InventoryState)`](/doc/models/inventory-state.md) | Optional | Indicates the state of a tracked item quantity in the lifecycle of goods. |
| `toState` | [`?string (InventoryState)`](/doc/models/inventory-state.md) | Optional | Indicates the state of a tracked item quantity in the lifecycle of goods. |
| `locationId` | `?string` | Optional | The Square ID of the [Location](#type-location) where the related<br>quantity of items are being tracked. |
| `catalogObjectId` | `?string` | Optional | The Square generated ID of the<br>`CatalogObject` being tracked. |
| `catalogObjectType` | `?string` | Optional | The `CatalogObjectType` of the<br>`CatalogObject` being tracked. Tracking is only<br>supported for the `ITEM_VARIATION` type. |
| `quantity` | `?string` | Optional | The number of items affected by the adjustment as a decimal string.<br>Can support up to 5 digits after the decimal point.<br><br>_Important_: The Point of Sale app and Dashboard do not currently support<br>decimal quantities. If a Point of Sale app or Dashboard attempts to read a<br>decimal quantity on inventory counts or adjustments, the quantity will be rounded<br>down to the nearest integer. For example, `2.5` will become `2`, and `-2.5`<br>will become `-3`.<br>Read [Decimal Quantities (BETA)](https://developer.squareup.com/docs/inventory-api/what-it-does#decimal-quantities-beta) for more information. |
| `totalPriceMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `occurredAt` | `?string` | Optional | A client-generated timestamp in RFC 3339 format that indicates when<br>the adjustment took place. For write actions, the `occurred_at`<br>timestamp cannot be older than 24 hours or in the future relative to the<br>time of the request. |
| `createdAt` | `?string` | Optional | A read-only timestamp in RFC 3339 format that indicates when Square<br>received the adjustment. |
| `source` | [`?SourceApplication`](/doc/models/source-application.md) | Optional | Provides information about the application used to generate an inventory<br>change. |
| `employeeId` | `?string` | Optional | The Square ID of the [Employee](#type-employee) responsible for the<br>inventory adjustment. |
| `transactionId` | `?string` | Optional | The read-only Square ID of the [Transaction][#type-transaction] that<br>caused the adjustment. Only relevant for payment-related state<br>transitions. |
| `refundId` | `?string` | Optional | The read-only Square ID of the [Refund][#type-refund] that<br>caused the adjustment. Only relevant for refund-related state<br>transitions. |
| `purchaseOrderId` | `?string` | Optional | The read-only Square ID of the purchase order that caused the<br>adjustment. Only relevant for state transitions from the Square for Retail<br>app. |
| `goodsReceiptId` | `?string` | Optional | The read-only Square ID of the Square goods receipt that caused the<br>adjustment. Only relevant for state transitions from the Square for Retail<br>app. |

### Example (as JSON)

```json
{
  "id": null,
  "reference_id": null,
  "from_state": null,
  "to_state": null,
  "location_id": null,
  "catalog_object_id": null,
  "catalog_object_type": null,
  "quantity": null,
  "total_price_money": null,
  "occurred_at": null,
  "created_at": null,
  "source": null,
  "employee_id": null,
  "transaction_id": null,
  "refund_id": null,
  "purchase_order_id": null,
  "goods_receipt_id": null
}
```

