## Dispute

Represents a dispute a cardholder initiated with their bank.

### Structure

`Dispute`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `disputeId` | `?string` | Optional | Unique ID for this `Dispute`, generated by Square. |
| `amountMoney` | [`?Money`](/doc/models/money.md) | Optional | Represents an amount of money. `Money` fields can be signed or unsigned.<br>Fields that do not explicitly define whether they are signed or unsigned are<br>considered unsigned and can only hold positive amounts. For signed fields, the<br>sign of the value indicates the purpose of the money transfer. See<br>[Working with Monetary Amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts)<br>for more information. |
| `reason` | [`?string (DisputeReason)`](/doc/models/dispute-reason.md) | Optional | List of possible reasons why a cardholder might initiate a<br>dispute with their bank. |
| `state` | [`?string (DisputeState)`](/doc/models/dispute-state.md) | Optional | List of possible dispute states. |
| `dueAt` | `?string` | Optional | The time when the next action is due, in RFC 3339 format. |
| `disputedPayment` | [`?DisputedPayment`](/doc/models/disputed-payment.md) | Optional | The payment the cardholder disputed. |
| `evidenceIds` | `?(string[])` | Optional | The IDs of the evidence associated with the dispute. |
| `cardBrand` | [`?string (CardBrand)`](/doc/models/card-brand.md) | Optional | Indicates a card's brand, such as `VISA` or `MASTERCARD`. |
| `createdAt` | `?string` | Optional | Timestamp when the dispute was created, in RFC 3339 format. |
| `updatedAt` | `?string` | Optional | Timestamp when dispute was last updated, in RFC 3339 format. |
| `brandDisputeId` | `?string` | Optional | ID of the dispute in the card brand system, generated by the card brand. |
| `reportedDate` | `?string` | Optional | Timestamp when the dispute was reported, in RFC 3339 format. |
| `version` | `?int` | Optional | The current version of the `Dispute`. |
| `locationId` | `?string` | Optional | The ID of location where dispute originated. |

### Example (as JSON)

```json
{
  "dispute_id": null,
  "amount_money": null,
  "reason": null,
  "state": null,
  "due_at": null,
  "disputed_payment": null,
  "evidence_ids": null,
  "card_brand": null,
  "created_at": null,
  "updated_at": null,
  "brand_dispute_id": null,
  "reported_date": null,
  "version": null,
  "location_id": null
}
```

