## Create Customer Card Response

Defines the fields that are included in the response body of
a request to the CreateCustomerCard endpoint.

One of `errors` or `card` is present in a given response (never both).

### Structure

`CreateCustomerCardResponse`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `errors` | [`?(Error[])`](/doc/models/error.md) | Optional | Any errors that occurred during the request. |
| `card` | [`?Card`](/doc/models/card.md) | Optional | Represents the payment details of a card to be used for payments. These<br>details are determined by the `card_nonce` generated by `SqPaymentForm`. |

### Example (as JSON)

```json
{
  "card": {
    "id": "icard-card_id",
    "card_brand": "VISA",
    "last_4": "1111",
    "exp_month": 11,
    "exp_year": 2018,
    "cardholder_name": "Amelia Earhart",
    "billing_address": {
      "address_line_1": "500 Electric Ave",
      "address_line_2": "Suite 600",
      "locality": "New York",
      "administrative_district_level_1": "NY",
      "postal_code": "10003",
      "country": "US"
    }
  }
}
```

