## Create Customer Card Request

Defines the fields that are included in the request body of a request
to the CreateCustomerCard endpoint.

### Structure

`CreateCustomerCardRequest`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `cardNonce` | `string` |  | A card nonce representing the credit card to link to the customer.<br><br>Card nonces are generated by the Square Payment Form when customers enter<br>their card information. See<br>[Embedding the payment form](https://developer.squareup.com/docs/payment-form/payment-form-walkthrough) for<br>more information.<br><br>__NOTE:__ Card nonces generated by digital wallets (e.g., Apple Pay)<br>cannot be used to create a customer card. |
| `billingAddress` | [`?Address`](/doc/models/address.md) | Optional | Represents a physical address. |
| `cardholderName` | `?string` | Optional | The full name printed on the credit card. |
| `verificationToken` | `?string` | Optional | An identifying token generated by `SqPaymentForm.verifyBuyer()`.<br>Verification tokens encapsulate customer device information and 3-D Secure<br>challenge results to indicate that Square has verified the buyer identity. |

### Example (as JSON)

```json
{
  "card_nonce": "YOUR_CARD_NONCE",
  "billing_address": {
    "address_line_1": "500 Electric Ave",
    "address_line_2": "Suite 600",
    "locality": "New York",
    "administrative_district_level_1": "NY",
    "postal_code": "10003",
    "country": "US"
  },
  "cardholder_name": "Amelia Earhart"
}
```

