## Card

Represents the payment details of a card to be used for payments. These
details are determined by the `card_nonce` generated by `SqPaymentForm`.

### Structure

`Card`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `id` | `?string` | Optional | Unique ID for this card. Generated by Square. |
| `cardBrand` | [`?string (CardBrand)`](/doc/models/card-brand.md) | Optional | Indicates a card's brand, such as `VISA` or `MASTERCARD`. |
| `last4` | `?string` | Optional | The last 4 digits of the card number. |
| `expMonth` | `?int` | Optional | The expiration month of the associated card as an integer between 1 and 12. |
| `expYear` | `?int` | Optional | The four-digit year of the card's expiration date. |
| `cardholderName` | `?string` | Optional | The name of the cardholder. |
| `billingAddress` | [`?Address`](/doc/models/address.md) | Optional | Represents a physical address. |
| `fingerprint` | `?string` | Optional | __Not currently set.__ Intended as a Square-assigned identifier, based<br>on the card number, to identify the card across multiple locations within a<br>single application. |
| `cardType` | [`?string (CardType)`](/doc/models/card-type.md) | Optional | Indicates a card's type, such as `CREDIT` or `DEBIT`. |
| `prepaidType` | [`?string (CardPrepaidType)`](/doc/models/card-prepaid-type.md) | Optional | Indicates a card's prepaid type, such as `NOT_PREPAID` or `PREPAID`. |
| `bin` | `?string` | Optional | The first six digits of the card number, known as the Bank Identification Number (BIN). Only the Payments API<br>returns this field. |

### Example (as JSON)

```json
{
  "id": null,
  "card_brand": null,
  "last_4": null,
  "exp_month": null,
  "exp_year": null,
  "cardholder_name": null,
  "billing_address": null,
  "fingerprint": null,
  "card_type": null,
  "prepaid_type": null,
  "bin": null
}
```

