## Card Payment Details

Reflects the current status of a card payment.

### Structure

`CardPaymentDetails`

### Fields

| Name | Type | Tags | Description |
|  --- | --- | --- | --- |
| `status` | `?string` | Optional | The card payment's current state. It can be one of: `AUTHORIZED`, `CAPTURED`, `VOIDED`,<br>`FAILED`. |
| `card` | [`?Card`](/doc/models/card.md) | Optional | Represents the payment details of a card to be used for payments. These<br>details are determined by the `card_nonce` generated by `SqPaymentForm`. |
| `entryMethod` | `?string` | Optional | The method used to enter the card's details for the payment.  Can be<br>`KEYED`, `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`. |
| `cvvStatus` | `?string` | Optional | Status code returned from the Card Verification Value (CVV) check. Can be<br>`CVV_ACCEPTED`, `CVV_REJECTED`, `CVV_NOT_CHECKED`. |
| `avsStatus` | `?string` | Optional | Status code returned from the Address Verification System (AVS) check. Can be<br>`AVS_ACCEPTED`, `AVS_REJECTED`, `AVS_NOT_CHECKED`. |
| `authResultCode` | `?string` | Optional | Status code returned by the card issuer that describes the payment's<br>authorization status. |
| `applicationIdentifier` | `?string` | Optional | For EMV payments, identifies the EMV application used for the payment. |
| `applicationName` | `?string` | Optional | For EMV payments, the human-readable name of the EMV application used for the payment. |
| `applicationCryptogram` | `?string` | Optional | For EMV payments, the cryptogram generated for the payment. |
| `verificationMethod` | `?string` | Optional | For EMV payments, method used to verify the cardholder's identity.  Can be one of<br>`PIN`, `SIGNATURE`, `PIN_AND_SIGNATURE`, `ON_DEVICE`, or `NONE`. |
| `verificationResults` | `?string` | Optional | For EMV payments, the results of the cardholder verification.  Can be one of<br>`SUCCESS`, `FAILURE`, or `UNKNOWN`. |
| `statementDescription` | `?string` | Optional | The statement description sent to the card networks.<br><br>Note: The actual statement description will vary and is likely to be truncated and appended with<br>additional information on a per issuer basis. |
| `deviceDetails` | [`?DeviceDetails`](/doc/models/device-details.md) | Optional | Details about the device that took the payment. |
| `errors` | [`?(Error[])`](/doc/models/error.md) | Optional | Information on errors encountered during the request. |

### Example (as JSON)

```json
{
  "status": null,
  "card": null,
  "entry_method": null,
  "cvv_status": null,
  "avs_status": null,
  "auth_result_code": null,
  "application_identifier": null,
  "application_name": null,
  "application_cryptogram": null,
  "verification_method": null,
  "verification_results": null,
  "statement_description": null,
  "device_details": null,
  "errors": null
}
```

